/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;

@PublicEvolving
public class EnvironmentSettings {
    private static final EnvironmentSettings DEFAULT_STREAMING_MODE_SETTINGS = EnvironmentSettings.newInstance().inStreamingMode().build();
    private static final EnvironmentSettings DEFAULT_BATCH_MODE_SETTINGS = EnvironmentSettings.newInstance().inBatchMode().build();
    public static final String DEFAULT_BUILTIN_CATALOG = "default_catalog";
    public static final String DEFAULT_BUILTIN_DATABASE = "default_database";
    private final String planner;
    private final String executor;
    private final String builtInCatalogName;
    private final String builtInDatabaseName;
    private final boolean isStreamingMode;

    private EnvironmentSettings(String planner, @Nullable String executor, String builtInCatalogName, String builtInDatabaseName, boolean isStreamingMode) {
        this.planner = planner;
        this.executor = executor;
        this.builtInCatalogName = builtInCatalogName;
        this.builtInDatabaseName = builtInDatabaseName;
        this.isStreamingMode = isStreamingMode;
    }

    public static EnvironmentSettings inStreamingMode() {
        return DEFAULT_STREAMING_MODE_SETTINGS;
    }

    public static EnvironmentSettings inBatchMode() {
        return DEFAULT_BATCH_MODE_SETTINGS;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public static EnvironmentSettings fromConfiguration(ReadableConfig configuration) {
        Builder builder = new Builder();
        switch ((RuntimeExecutionMode)configuration.get(ExecutionOptions.RUNTIME_MODE)) {
            case STREAMING: {
                builder.inStreamingMode();
                break;
            }
            case BATCH: {
                builder.inBatchMode();
                break;
            }
            default: {
                throw new TableException(String.format("Unsupported mode '%s' for '%s'. Only an explicit BATCH or STREAMING mode is supported in Table API.", configuration.get(ExecutionOptions.RUNTIME_MODE), ExecutionOptions.RUNTIME_MODE.key()));
            }
        }
        switch ((PlannerType)((Object)configuration.get(TableConfigOptions.TABLE_PLANNER))) {
            case BLINK: {
                builder.useBlinkPlanner();
                break;
            }
            case OLD: {
                builder.useOldPlanner();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unrecognized value '%s' for option '%s'.", configuration.get(TableConfigOptions.TABLE_PLANNER), TableConfigOptions.TABLE_PLANNER.key()));
            }
        }
        return builder.build();
    }

    public Configuration toConfiguration() {
        Configuration configuration = new Configuration();
        configuration.set(ExecutionOptions.RUNTIME_MODE, (Object)(this.isStreamingMode() ? RuntimeExecutionMode.STREAMING : RuntimeExecutionMode.BATCH));
        configuration.set(TableConfigOptions.TABLE_PLANNER, (Object)PlannerType.BLINK);
        return configuration;
    }

    public String getBuiltInCatalogName() {
        return this.builtInCatalogName;
    }

    public String getBuiltInDatabaseName() {
        return this.builtInDatabaseName;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Deprecated
    public boolean isBlinkPlanner() {
        return true;
    }

    @Internal
    public String getPlanner() {
        return this.planner;
    }

    @Internal
    public String getExecutor() {
        return this.executor;
    }

    public static class Builder {
        private final String planner = "default";
        private final String executor = "default";
        private String builtInCatalogName = "default_catalog";
        private String builtInDatabaseName = "default_database";
        private boolean isStreamingMode = true;

        @Deprecated
        public Builder useOldPlanner() {
            throw new TableException("The old planner has been removed in Flink 1.14. Please upgrade your table program to use the default planner (previously called the 'blink' planner).");
        }

        @Deprecated
        public Builder useBlinkPlanner() {
            return this;
        }

        @Deprecated
        public Builder useAnyPlanner() {
            return this;
        }

        public Builder inBatchMode() {
            this.isStreamingMode = false;
            return this;
        }

        public Builder inStreamingMode() {
            this.isStreamingMode = true;
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.builtInCatalogName = builtInCatalogName;
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.builtInDatabaseName = builtInDatabaseName;
            return this;
        }

        public EnvironmentSettings build() {
            return new EnvironmentSettings("default", "default", this.builtInCatalogName, this.builtInDatabaseName, this.isStreamingMode);
        }
    }
}

