/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class UserDefinedFunctionHelper {
    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<T> scalaType) {
        TypeInformation userProvidedType = aggregateFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)0);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<ACC> scalaType) {
        TypeInformation userProvidedType = aggregateFunction.getAccumulatorType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)1);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction) {
        return UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tableFunction, null);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction, TypeInformation<T> scalaType) {
        TypeInformation userProvidedType = tableFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(tableFunction, TableFunction.class, tableFunction.getClass(), (int)0);
    }

    public static void prepareFunction(TableConfig config, UserDefinedFunction function) {
        if (function instanceof TableFunction) {
            UserDefinedFunctionHelper.validateNotSingleton(function.getClass());
        }
        UserDefinedFunctionHelper.validateInstantiation(function.getClass());
        UserDefinedFunctionHelper.cleanFunction(config, function);
    }

    private static void validateInstantiation(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            throw new ValidationException(String.format("Function class %s is not public.", clazz.getCanonicalName()));
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            throw new ValidationException(String.format("Function class %s is no proper class, it is either abstract, an interface, or a primitive type.", clazz.getCanonicalName()));
        }
    }

    private static void validateNotSingleton(Class<?> clazz) {
        if (Arrays.stream(clazz.getFields()).anyMatch(f -> f.getName().equals("MODULE$"))) {
            throw new ValidationException(String.format("Function implemented by class %s is a Scala object. This is forbidden because of concurrency problems when using them.", clazz.getCanonicalName()));
        }
    }

    private static void cleanFunction(TableConfig config, UserDefinedFunction function) {
        ExecutionConfig.ClosureCleanerLevel level = (ExecutionConfig.ClosureCleanerLevel)config.getConfiguration().get(PipelineOptions.CLOSURE_CLEANER_LEVEL);
        try {
            ClosureCleaner.clean((Object)function, (ExecutionConfig.ClosureCleanerLevel)level, (boolean)true);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Function class '%s' is not serializable. Make sure that the class is self-contained (i.e. no references to outer classes) and all inner fields are serializable as well.", function.getClass()), t);
        }
    }

    private UserDefinedFunctionHelper() {
    }
}

