/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils.factories;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.expressions.utils.ApiExpressionUtils;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.operations.QueryOperation;

@Internal
public final class AliasOperationUtils {
    private static final AliasLiteralValidator aliasLiteralValidator = new AliasLiteralValidator();
    private static final String ALL_REFERENCE = "*";

    public static List<Expression> createAliasList(List<Expression> aliases, QueryOperation child) {
        TableSchema childSchema = child.getTableSchema();
        if (aliases.size() > childSchema.getFieldCount()) {
            throw new ValidationException("Aliasing more fields than we actually have.");
        }
        List fieldAliases = aliases.stream().map(f -> (ValueLiteralExpression)f.accept((ExpressionVisitor)aliasLiteralValidator)).collect(Collectors.toList());
        String[] childNames = childSchema.getFieldNames();
        return IntStream.range(0, childNames.length).mapToObj(idx -> {
            UnresolvedReferenceExpression oldField = ApiExpressionUtils.unresolvedRef(childNames[idx]);
            if (idx < fieldAliases.size()) {
                ValueLiteralExpression alias = (ValueLiteralExpression)fieldAliases.get(idx);
                return ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AS, new Expression[]{oldField, alias});
            }
            return oldField;
        }).collect(Collectors.toList());
    }

    private AliasOperationUtils() {
    }

    private static class AliasLiteralValidator
    extends ApiExpressionDefaultVisitor<ValueLiteralExpression> {
        private AliasLiteralValidator() {
        }

        @Override
        public ValueLiteralExpression visit(ValueLiteralExpression valueLiteral) {
            String name = (String)ExpressionUtils.extractValue((Expression)valueLiteral, String.class).orElseThrow(() -> new ValidationException("Alias accepts only names that are not '*' reference."));
            if (name.equals(AliasOperationUtils.ALL_REFERENCE)) {
                throw new ValidationException("Alias can not accept '*' as name.");
            }
            return valueLiteral;
        }

        @Override
        protected ValueLiteralExpression defaultMethod(Expression expression) {
            throw new ValidationException("Alias accepts only names that are not '*' reference.");
        }

        @Override
        public ValueLiteralExpression visit(UnresolvedReferenceExpression unresolvedReference) {
            if (unresolvedReference.getName().equals(AliasOperationUtils.ALL_REFERENCE)) {
                throw new ValidationException("Alias can not accept '*' as name.");
            }
            return ApiExpressionUtils.valueLiteral(unresolvedReference.getName());
        }
    }
}

