/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.DropOperation;

public class DropTableOperation
implements DropOperation {
    private final ObjectIdentifier tableIdentifier;
    private final boolean ifExists;

    public DropTableOperation(ObjectIdentifier tableIdentifier, boolean ifExists) {
        this.tableIdentifier = tableIdentifier;
        this.ifExists = ifExists;
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("identifier", this.tableIdentifier);
        params.put("IfExists", this.ifExists);
        return OperationUtils.formatWithChildren("DROP TABLE", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

