/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.AlterOperation;

public class AlterFunctionOperation
implements AlterOperation {
    private final ObjectIdentifier functionIdentifier;
    private CatalogFunction catalogFunction;
    private boolean ifExists;
    private boolean isTemporary;

    public AlterFunctionOperation(ObjectIdentifier functionIdentifier, CatalogFunction catalogFunction, boolean ifExists, boolean isTemporary) {
        this.functionIdentifier = functionIdentifier;
        this.catalogFunction = catalogFunction;
        this.ifExists = ifExists;
        this.isTemporary = isTemporary;
    }

    public CatalogFunction getCatalogFunction() {
        return this.catalogFunction;
    }

    public ObjectIdentifier getFunctionIdentifier() {
        return this.functionIdentifier;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogFunction", this.catalogFunction.getDetailedDescription());
        params.put("identifier", this.functionIdentifier);
        params.put("ifExists", this.ifExists);
        params.put("isTemporary", this.isTemporary);
        return OperationUtils.formatWithChildren("ALTER FUNCTION", params, Collections.emptyList(), Operation::asSummaryString);
    }

    public String getFunctionName() {
        return this.functionIdentifier.getObjectName();
    }
}

