/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class JoinQueryOperation
implements QueryOperation {
    private final QueryOperation left;
    private final QueryOperation right;
    private final JoinType joinType;
    private final ResolvedExpression condition;
    private final boolean correlated;
    private final TableSchema tableSchema;

    public JoinQueryOperation(QueryOperation left, QueryOperation right, JoinType joinType, ResolvedExpression condition, boolean correlated) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.condition = condition;
        this.correlated = correlated;
        this.tableSchema = this.calculateResultingSchema(left, right);
    }

    private TableSchema calculateResultingSchema(QueryOperation left, QueryOperation right) {
        TableSchema leftSchema = left.getTableSchema();
        TableSchema rightSchema = right.getTableSchema();
        int resultingSchemaSize = leftSchema.getFieldCount() + rightSchema.getFieldCount();
        String[] newFieldNames = new String[resultingSchemaSize];
        System.arraycopy(leftSchema.getFieldNames(), 0, newFieldNames, 0, leftSchema.getFieldCount());
        System.arraycopy(rightSchema.getFieldNames(), 0, newFieldNames, leftSchema.getFieldCount(), rightSchema.getFieldCount());
        TypeInformation[] newFieldTypes = new TypeInformation[resultingSchemaSize];
        System.arraycopy(leftSchema.getFieldTypes(), 0, newFieldTypes, 0, leftSchema.getFieldCount());
        System.arraycopy(rightSchema.getFieldTypes(), 0, newFieldTypes, leftSchema.getFieldCount(), rightSchema.getFieldCount());
        return new TableSchema(newFieldNames, newFieldTypes);
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ResolvedExpression getCondition() {
        return this.condition;
    }

    public boolean isCorrelated() {
        return this.correlated;
    }

    @Override
    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("joinType", (Object)this.joinType);
        args.put("condition", this.condition);
        args.put("correlated", this.correlated);
        return OperationUtils.formatWithChildren("Join", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static enum JoinType {
        INNER,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }
}

