/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.UserDefinedType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class DistinctType
extends UserDefinedType {
    private static final long serialVersionUID = 1L;
    private final LogicalType sourceType;

    private DistinctType(ObjectIdentifier objectIdentifier, LogicalType sourceType, @Nullable String description) {
        super(sourceType.isNullable(), LogicalTypeRoot.DISTINCT_TYPE, objectIdentifier, true, description);
        this.sourceType = (LogicalType)Preconditions.checkNotNull((Object)sourceType, (String)"Source type must not be null.");
    }

    public static Builder newBuilder(ObjectIdentifier objectIdentifier, LogicalType sourceType) {
        return new Builder(objectIdentifier, sourceType);
    }

    public LogicalType getSourceType() {
        return this.sourceType;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new DistinctType(this.getObjectIdentifier().orElseThrow(IllegalStateException::new), this.sourceType.copy(isNullable), this.getDescription().orElse(null));
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return this.sourceType.supportsInputConversion(clazz);
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return this.sourceType.supportsOutputConversion(clazz);
    }

    @Override
    public Class<?> getDefaultConversion() {
        return this.sourceType.getDefaultConversion();
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.singletonList(this.sourceType);
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DistinctType that = (DistinctType)o;
        return this.sourceType.equals(that.sourceType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceType);
    }

    @PublicEvolving
    public static final class Builder {
        private final ObjectIdentifier objectIdentifier;
        private final LogicalType sourceType;
        @Nullable
        private String description;

        public Builder(ObjectIdentifier objectIdentifier, LogicalType sourceType) {
            this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
            this.sourceType = (LogicalType)Preconditions.checkNotNull((Object)sourceType, (String)"Source type must not be null.");
            Preconditions.checkArgument((!sourceType.getTypeRoot().getFamilies().contains((Object)LogicalTypeFamily.USER_DEFINED) ? 1 : 0) != 0, (Object)"Source type must not be a user-defined type.");
        }

        public Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (String)"Description must not be null");
            return this;
        }

        public DistinctType build() {
            return new DistinctType(this.objectIdentifier, this.sourceType, this.description);
        }
    }
}

