/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.io.Serializable;
import java.sql.Date;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.catalog.FileCatalogStoreFactoryOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.ProviderContext;
import org.apache.flink.table.connector.sink.DataStreamSinkProvider;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.sinks.LegacyCsvDynamicTableSinkOptions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.Row;

@Deprecated
@Internal
public class LegacyCsvDynamicTableSinkFactory
implements DynamicTableSinkFactory {
    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ResolvedSchema schema = context.getCatalogTable().getResolvedSchema();
        return new LegacyCsvDynamicTableSink((String)helper.getOptions().get(FileCatalogStoreFactoryOptions.PATH), (String)helper.getOptions().get(LegacyCsvDynamicTableSinkOptions.FIELD_DELIM), (Integer)helper.getOptions().get(LegacyCsvDynamicTableSinkOptions.NUM_FILES), (FileSystem.WriteMode)helper.getOptions().get(LegacyCsvDynamicTableSinkOptions.WRITE_MODE), schema.getColumnNames().toArray(new String[0]), schema.getColumnDataTypes().toArray(new DataType[0]));
    }

    public String factoryIdentifier() {
        return "legacy-csv";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.singleton(FileCatalogStoreFactoryOptions.PATH);
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(LegacyCsvDynamicTableSinkOptions.FIELD_DELIM);
        set.add(LegacyCsvDynamicTableSinkOptions.NUM_FILES);
        set.add(LegacyCsvDynamicTableSinkOptions.WRITE_MODE);
        return set;
    }

    @Deprecated
    @Internal
    public static class LegacyCsvDynamicTableSink
    implements DynamicTableSink {
        private final String path;
        private final String fieldDelim;
        private final int numFiles;
        @Nullable
        private final FileSystem.WriteMode writeMode;
        private final String[] fieldNames;
        private final DataType[] fieldTypes;

        public LegacyCsvDynamicTableSink(String path, String fieldDelim, int numFiles, @Nullable FileSystem.WriteMode writeMode, String[] fieldNames, DataType[] fieldTypes) {
            this.path = path;
            this.fieldDelim = fieldDelim;
            this.numFiles = numFiles;
            this.writeMode = writeMode;
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
        }

        public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
            return ChangelogMode.insertOnly();
        }

        public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
            return new DataStreamSinkProvider(){

                @Override
                public DataStreamSink<?> consumeDataStream(ProviderContext providerContext, DataStream<RowData> dataStream) {
                    CsvTableSink sink = new CsvTableSink(path, fieldDelim, numFiles, writeMode, fieldNames, fieldTypes);
                    SingleOutputStreamOperator dataStreamWithRow = dataStream.map((MapFunction)new RowDataToRow(fieldTypes));
                    this.getParallelism().ifPresent(arg_0 -> ((SingleOutputStreamOperator)dataStreamWithRow).setParallelism(arg_0));
                    return sink.consumeDataStream((DataStream<Row>)dataStreamWithRow);
                }

                @Override
                public Optional<Integer> getParallelism() {
                    if (numFiles > 0) {
                        return Optional.of(numFiles);
                    }
                    return DataStreamSinkProvider.super.getParallelism();
                }
            };
        }

        public DynamicTableSink copy() {
            return new LegacyCsvDynamicTableSink(this.path, this.fieldDelim, this.numFiles, this.writeMode, this.fieldNames, this.fieldTypes);
        }

        public String asSummaryString() {
            return "legacy-csv-sink";
        }

        private static class RowDataToRow
        implements MapFunction<RowData, Row> {
            private final RowData.FieldGetter[] fieldGetters;

            public RowDataToRow(DataType[] fieldTypes) {
                this.fieldGetters = new RowData.FieldGetter[fieldTypes.length];
                for (int i = 0; i < this.fieldGetters.length; ++i) {
                    this.fieldGetters[i] = this.getFieldGetter(fieldTypes[i].getLogicalType(), i);
                }
            }

            public Row map(RowData rowData) throws Exception {
                Row row = new Row(rowData.getRowKind(), rowData.getArity());
                for (int i = 0; i < rowData.getArity(); ++i) {
                    row.setField(i, this.fieldGetters[i].getFieldOrNull(rowData));
                }
                return row;
            }

            private RowData.FieldGetter getFieldGetter(LogicalType fieldType, int fieldPos) {
                switch (fieldType.getTypeRoot()) {
                    case DATE: {
                        return (RowData.FieldGetter & Serializable)row -> Date.valueOf(LocalDate.ofEpochDay(row.getInt(fieldPos)));
                    }
                }
                return RowData.createFieldGetter((LogicalType)fieldType, (int)fieldPos);
            }
        }
    }
}

