/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.windowing.assigners.DynamicEventTimeSessionWindows;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.SessionWindowTimeGapExtractor;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.EventTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;

@PublicEvolving
public class EventTimeSessionWindows
extends MergingWindowAssigner<Object, TimeWindow> {
    private static final long serialVersionUID = 1L;
    protected long sessionTimeout;

    protected EventTimeSessionWindows(long sessionTimeout) {
        if (sessionTimeout <= 0L) {
            throw new IllegalArgumentException("EventTimeSessionWindows parameters must satisfy 0 < size");
        }
        this.sessionTimeout = sessionTimeout;
    }

    public Collection<TimeWindow> assignWindows(Object element, long timestamp, WindowAssigner.WindowAssignerContext context) {
        return Collections.singletonList(new TimeWindow(timestamp, timestamp + this.sessionTimeout));
    }

    public Trigger<Object, TimeWindow> getDefaultTrigger() {
        return EventTimeTrigger.create();
    }

    public String toString() {
        return "EventTimeSessionWindows(" + this.sessionTimeout + ")";
    }

    public static EventTimeSessionWindows withGap(Duration size) {
        return new EventTimeSessionWindows(size.toMillis());
    }

    @PublicEvolving
    public static <T> DynamicEventTimeSessionWindows<T> withDynamicGap(SessionWindowTimeGapExtractor<T> sessionWindowTimeGapExtractor) {
        return new DynamicEventTimeSessionWindows<T>(sessionWindowTimeGapExtractor);
    }

    public TypeSerializer<TimeWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new TimeWindow.Serializer();
    }

    public boolean isEventTime() {
        return true;
    }

    public void mergeWindows(Collection<TimeWindow> windows, MergingWindowAssigner.MergeCallback<TimeWindow> c) {
        TimeWindow.mergeWindows(windows, c);
    }
}

