/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.util.Preconditions;

public class CompletingCheckpointResponder
implements CheckpointResponder {
    private Consumer<Long> completeCheckpoint;
    private BiConsumer<Long, Long> abortCheckpoint;
    private final Set<Long> checkpointsToComplete = new HashSet<Long>();
    private long lastCompletedCheckpoint = -1L;

    public void setHandlers(Consumer<Long> completeCheckpoint, BiConsumer<Long, Long> abortCheckpoint) {
        this.completeCheckpoint = completeCheckpoint;
        this.abortCheckpoint = abortCheckpoint;
    }

    public void completeCheckpoints(Collection<Long> checkpointsToComplete) {
        this.checkpointsToComplete.addAll(checkpointsToComplete);
    }

    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        Preconditions.checkState((this.completeCheckpoint != null ? 1 : 0) != 0);
        if (!this.checkpointsToComplete.isEmpty()) {
            if (this.checkpointsToComplete.contains(checkpointId)) {
                this.completeCheckpoint(checkpointId);
            }
        } else {
            this.completeCheckpoint(checkpointId);
        }
    }

    private void completeCheckpoint(long checkpointId) {
        this.lastCompletedCheckpoint = checkpointId;
        this.completeCheckpoint.accept(checkpointId);
    }

    public void reportCheckpointMetrics(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void declineCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointException checkpointException) {
        Preconditions.checkState((this.abortCheckpoint != null ? 1 : 0) != 0);
        this.abortCheckpoint.accept(checkpointId, this.lastCompletedCheckpoint);
    }

    public void reportInitializationMetrics(JobID jobId, ExecutionAttemptID executionAttemptID, SubTaskInitializationMetrics initializationMetrics) {
    }
}

