/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.StreamMap;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.operators.StreamTaskTimerITCase;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.OneInputStreamTaskTestHarness;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TestProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestProcessingTimeServiceTest {
    TestProcessingTimeServiceTest() {
    }

    @Test
    void testCustomTimeServiceProvider() throws Throwable {
        TestProcessingTimeService tp = new TestProcessingTimeService();
        OneInputStreamTaskTestHarness testHarness = new OneInputStreamTaskTestHarness(env -> new OneInputStreamTask(env, (TimerService)tp), BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO);
        testHarness.setupOutputForSingletonOperatorChain();
        StreamConfig streamConfig = testHarness.getStreamConfig();
        StreamMap mapOperator = new StreamMap(new StreamTaskTimerITCase.DummyMapFunction());
        streamConfig.setStreamOperator((StreamOperator)mapOperator);
        streamConfig.setOperatorID(new OperatorID());
        testHarness.invoke();
        testHarness.waitForTaskRunning();
        ProcessingTimeService processingTimeService = ((StreamMap)testHarness.getHeadOperator()).getProcessingTimeService();
        Assertions.assertThat((long)processingTimeService.getCurrentProcessingTime()).isEqualTo(Long.MIN_VALUE);
        tp.setCurrentTime(11L);
        Assertions.assertThat((long)processingTimeService.getCurrentProcessingTime()).isEqualTo(11L);
        tp.setCurrentTime(15L);
        tp.setCurrentTime(16L);
        Assertions.assertThat((long)processingTimeService.getCurrentProcessingTime()).isEqualTo(16L);
        processingTimeService.registerTimer(30L, timestamp -> {});
        processingTimeService.registerTimer(40L, timestamp -> {});
        Assertions.assertThat((int)tp.getNumActiveTimers()).isEqualTo(2);
        tp.setCurrentTime(35L);
        Assertions.assertThat((int)tp.getNumActiveTimers()).isOne();
        tp.setCurrentTime(40L);
        Assertions.assertThat((int)tp.getNumActiveTimers()).isZero();
        tp.shutdownService();
    }
}

