/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.experimental;

import java.net.Socket;
import java.util.Iterator;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.streaming.experimental.SocketStreamIterator;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SocketStreamIteratorTest {
    SocketStreamIteratorTest() {
    }

    @Test
    void testIterator() throws Exception {
        final long seed = new Random().nextLong();
        int numElements = 1000;
        final SocketStreamIterator iterator = new SocketStreamIterator((TypeSerializer)LongSerializer.INSTANCE);
        CheckedThread writer = new CheckedThread(){

            public void go() throws Exception {
                try (Socket sock = new Socket(iterator.getBindAddress(), iterator.getPort());
                     DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(sock.getOutputStream());){
                    LongSerializer serializer = LongSerializer.INSTANCE;
                    Random rnd = new Random(seed);
                    for (int i = 0; i < 1000; ++i) {
                        serializer.serialize((Object)rnd.nextLong(), (DataOutputView)out);
                    }
                }
            }
        };
        writer.start();
        Random validator = new Random(seed);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat((Iterator)iterator).hasNext();
            Assertions.assertThat((Iterator)iterator).hasNext();
            Assertions.assertThat((Long)((Long)iterator.next())).isEqualTo(validator.nextLong());
        }
        Assertions.assertThat((Iterator)iterator).isExhausted();
        writer.sync();
        Assertions.assertThat((Iterator)iterator).isExhausted();
    }

    @Test
    void testIteratorWithException() throws Exception {
        final SocketStreamIterator iterator = new SocketStreamIterator((TypeSerializer)LongSerializer.INSTANCE);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                iterator.notifyOfError((Throwable)new Exception("test"));
            }
        }.start();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SocketStreamIterator)iterator).hasNext()).isInstanceOf(RuntimeException.class)).hasMessageContaining("test");
    }
}

