/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.util.CollectorOutput;
import org.assertj.core.api.Assertions;

class QueueUtil {
    QueueUtil() {
    }

    static ResultFuture<Integer> putSuccessfully(StreamElementQueue<Integer> queue, StreamElement streamElement) {
        Optional resultFuture = queue.tryPut(streamElement);
        Assertions.assertThat((Optional)resultFuture).isPresent();
        return (ResultFuture)resultFuture.get();
    }

    static void putUnsuccessfully(StreamElementQueue<Integer> queue, StreamElement streamElement) {
        Optional resultFuture = queue.tryPut(streamElement);
        Assertions.assertThat((Optional)resultFuture).isNotPresent();
    }

    static List<StreamElement> popCompleted(StreamElementQueue<Integer> queue) {
        ArrayList<StreamElement> completed = new ArrayList<StreamElement>();
        TimestampedCollector collector = new TimestampedCollector((Output)new CollectorOutput(completed));
        while (queue.hasCompletedElements()) {
            queue.emitCompletedElement(collector);
        }
        collector.close();
        return completed;
    }
}

