/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketState;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketStatePathResolver;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketStateSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.RowWiseBucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.util.FileUtils;

public class BucketStateGenerator {
    private final String bucketId;
    private final String inProgressContent;
    private final String pendingContent;
    private final BucketStatePathResolver pathResolver;

    public BucketStateGenerator(String bucketId, String inProgressContent, String pendingContent, java.nio.file.Path basePath, int currentVersion) {
        this.bucketId = bucketId;
        this.inProgressContent = inProgressContent;
        this.pendingContent = pendingContent;
        this.pathResolver = new BucketStatePathResolver(basePath, currentVersion);
    }

    public void prepareDeserializationEmpty() throws IOException {
        String scenarioName = "empty";
        java.nio.file.Path scenarioPath = this.pathResolver.getResourcePath("empty");
        FileUtils.deleteDirectory((File)scenarioPath.toFile());
        Files.createDirectories(scenarioPath, new FileAttribute[0]);
        java.nio.file.Path outputPath = this.pathResolver.getOutputPath("empty");
        Path testBucketPath = new Path(outputPath.resolve(this.bucketId).toString());
        Bucket<String, String> bucket = this.createNewBucket(testBucketPath);
        BucketState bucketState = bucket.onReceptionOfCheckpoint(0L);
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize(BucketStateGenerator.bucketStateSerializer(), (Object)bucketState);
        Files.write(this.pathResolver.getSnapshotPath("empty"), bytes, new OpenOption[0]);
    }

    public void prepareDeserializationOnlyInProgress() throws IOException {
        String scenarioName = "only-in-progress";
        java.nio.file.Path scenarioPath = this.pathResolver.getResourcePath("only-in-progress");
        FileUtils.deleteDirectory((File)scenarioPath.toFile());
        Files.createDirectories(scenarioPath, new FileAttribute[0]);
        java.nio.file.Path outputPath = this.pathResolver.getOutputPath("only-in-progress");
        Path testBucketPath = new Path(outputPath.resolve(this.bucketId).toString());
        Bucket<String, String> bucket = this.createNewBucket(testBucketPath);
        bucket.write((Object)this.inProgressContent, System.currentTimeMillis());
        BucketState bucketState = bucket.onReceptionOfCheckpoint(0L);
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize(BucketStateGenerator.bucketStateSerializer(), (Object)bucketState);
        Files.write(this.pathResolver.getSnapshotPath("only-in-progress"), bytes, new OpenOption[0]);
    }

    public void prepareDeserializationFull() throws IOException {
        this.prepareDeserializationFull(true, "full");
    }

    public void prepareDeserializationNullInProgress() throws IOException {
        this.prepareDeserializationFull(false, "full-no-in-progress");
    }

    private void prepareDeserializationFull(boolean withInProgress, String scenarioName) throws IOException {
        java.nio.file.Path scenarioPath = this.pathResolver.getResourcePath(scenarioName);
        FileUtils.deleteDirectory((File)Paths.get(scenarioPath.toString() + "-template", new String[0]).toFile());
        Files.createDirectories(scenarioPath, new FileAttribute[0]);
        int noOfPendingCheckpoints = 5;
        java.nio.file.Path outputPath = this.pathResolver.getOutputPath(scenarioName);
        Path testBucketPath = new Path(outputPath.resolve(this.bucketId).toString());
        Bucket<String, String> bucket = this.createNewBucket(testBucketPath);
        BucketState bucketState = null;
        for (int i = 0; i < 5; ++i) {
            bucket.write((Object)this.pendingContent, System.currentTimeMillis());
            bucket.write((Object)this.pendingContent, System.currentTimeMillis());
            bucketState = bucket.onReceptionOfCheckpoint((long)i);
        }
        if (withInProgress) {
            bucket.write((Object)this.inProgressContent, System.currentTimeMillis());
            bucketState = bucket.onReceptionOfCheckpoint(5L);
        }
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize(BucketStateGenerator.bucketStateSerializer(), bucketState);
        Files.write(this.pathResolver.getSnapshotPath(scenarioName), bytes, new OpenOption[0]);
        this.moveToTemplateDirectory(scenarioPath);
    }

    private static RowWiseBucketWriter<String, String> createBucketWriter() throws IOException {
        return new RowWiseBucketWriter(FileSystem.getLocalFileSystem().createRecoverableWriter(), (Encoder)new SimpleStringEncoder());
    }

    private static SimpleVersionedSerializer<BucketState<String>> bucketStateSerializer() throws IOException {
        RowWiseBucketWriter<String, String> bucketWriter = BucketStateGenerator.createBucketWriter();
        return new BucketStateSerializer(bucketWriter.getProperties().getInProgressFileRecoverableSerializer(), bucketWriter.getProperties().getPendingFileRecoverableSerializer(), (SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE);
    }

    private Bucket<String, String> createNewBucket(Path bucketPath) throws IOException {
        return Bucket.getNew((int)0, (Object)this.bucketId, (Path)bucketPath, (long)0L, BucketStateGenerator.createBucketWriter(), (RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(new MemorySize(10L)).build(), null, (OutputFileConfig)OutputFileConfig.builder().build());
    }

    private void moveToTemplateDirectory(java.nio.file.Path scenarioPath) throws IOException {
        FileUtils.copy((Path)new Path(scenarioPath.toString()), (Path)new Path(scenarioPath.toString() + "-template"), (boolean)false);
        FileUtils.deleteDirectory((File)scenarioPath.toFile());
    }
}

