/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.async.queue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.operators.async.queue.OrderedStreamElementQueue;
import org.apache.flink.streaming.api.operators.async.queue.QueueUtil;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueue;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class OrderedStreamElementQueueTest {
    @Test
    void testCompletionOrder() {
        OrderedStreamElementQueue queue = new OrderedStreamElementQueue(4);
        ResultFuture<Integer> entry1 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)1, 0L));
        ResultFuture<Integer> entry2 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)2, 1L));
        QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new Watermark(2L));
        ResultFuture<Integer> entry4 = QueueUtil.putSuccessfully((StreamElementQueue<Integer>)queue, (StreamElement)new StreamRecord((Object)3, 3L));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
        Assertions.assertThat((int)queue.size()).isEqualTo(4L);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        entry2.complete(Collections.singleton(11));
        entry4.complete(Collections.singleton(13));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEmpty();
        Assertions.assertThat((int)queue.size()).isEqualTo(4L);
        Assertions.assertThat((boolean)queue.isEmpty()).isFalse();
        entry1.complete(Collections.singleton(10));
        List<StreamElement> expected = Arrays.asList(new StreamRecord((Object)10, 0L), new StreamRecord((Object)11, 1L), new Watermark(2L), new StreamRecord((Object)13, 3L));
        Assertions.assertThat(QueueUtil.popCompleted((StreamElementQueue<Integer>)queue)).isEqualTo(expected);
        Assertions.assertThat((int)queue.size()).isZero();
        Assertions.assertThat((boolean)queue.isEmpty()).isTrue();
    }
}

