/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.streaming.api.datastream.StreamProjection;
import org.apache.flink.streaming.api.operators.StreamProject;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.junit.jupiter.api.Test;

class StreamProjectTest {
    StreamProjectTest() {
    }

    @Test
    void testProject() throws Exception {
        TypeInformation inType = TypeExtractor.getForObject((Object)new Tuple5((Object)2, (Object)"a", (Object)3, (Object)"b", (Object)4));
        int[] fields = new int[]{4, 4, 3};
        TupleSerializer serializer = new TupleTypeInfo(StreamProjection.extractFieldTypes((int[])fields, (TypeInformation)inType)).createSerializer((SerializerConfig)new SerializerConfigImpl());
        StreamProject operator = new StreamProject(fields, (TypeSerializer)serializer);
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)new Tuple5((Object)2, (Object)"a", (Object)3, (Object)"b", (Object)4), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)new Tuple5((Object)2, (Object)"s", (Object)3, (Object)"c", (Object)2), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)new Tuple5((Object)2, (Object)"a", (Object)3, (Object)"c", (Object)2), initialTime + 3L));
        testHarness.processWatermark(new Watermark(initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)new Tuple5((Object)2, (Object)"a", (Object)3, (Object)"a", (Object)7), initialTime + 4L));
        expectedOutput.add(new StreamRecord((Object)new Tuple3((Object)4, (Object)4, (Object)"b"), initialTime + 1L));
        expectedOutput.add(new StreamRecord((Object)new Tuple3((Object)2, (Object)2, (Object)"c"), initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)new Tuple3((Object)2, (Object)2, (Object)"c"), initialTime + 3L));
        expectedOutput.add(new Watermark(initialTime + 2L));
        expectedOutput.add(new StreamRecord((Object)new Tuple3((Object)7, (Object)7, (Object)"a"), initialTime + 4L));
        TestHarnessUtil.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }
}

