/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.lineage;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.streaming.api.lineage.DefaultLineageGraph;
import org.apache.flink.streaming.api.lineage.LineageDataset;
import org.apache.flink.streaming.api.lineage.LineageEdge;
import org.apache.flink.streaming.api.lineage.LineageGraph;
import org.apache.flink.streaming.api.lineage.LineageVertex;
import org.apache.flink.streaming.api.lineage.SourceLineageVertex;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultLineageGraphTest {
    DefaultLineageGraphTest() {
    }

    @Test
    void testLineageGraph() {
        TestingSourceLineageVertex source1 = new TestingSourceLineageVertex("source1");
        TestingSourceLineageVertex source2 = new TestingSourceLineageVertex("source2");
        TestingSourceLineageVertex source3 = new TestingSourceLineageVertex("source3");
        TestingLineageVertex sink1 = new TestingLineageVertex("sink1");
        TestingLineageVertex sink2 = new TestingLineageVertex("sink2");
        LineageGraph lineageGraph = DefaultLineageGraph.builder().addLineageEdge((LineageEdge)new TestingLineageEdge(source1, sink1)).addLineageEdges(new LineageEdge[]{new TestingLineageEdge(source2, sink2), new TestingLineageEdge(source3, sink1), new TestingLineageEdge(source1, sink2)}).build();
        Assertions.assertThat((List)lineageGraph.sources()).containsExactlyInAnyOrder((Object[])new SourceLineageVertex[]{source1, source2, source3});
        Assertions.assertThat((List)lineageGraph.sinks()).containsExactlyInAnyOrder((Object[])new LineageVertex[]{sink1, sink2});
        Assertions.assertThat((List)lineageGraph.relations()).hasSize(4);
    }

    static class TestingLineageEdge
    implements LineageEdge {
        private final SourceLineageVertex source;
        private final LineageVertex sink;

        private TestingLineageEdge(SourceLineageVertex source, LineageVertex sink) {
            this.source = source;
            this.sink = sink;
        }

        public SourceLineageVertex source() {
            return this.source;
        }

        public LineageVertex sink() {
            return this.sink;
        }
    }

    static class TestingSourceLineageVertex
    extends TestingLineageVertex
    implements SourceLineageVertex {
        private TestingSourceLineageVertex(String id) {
            super(id);
        }

        public Boundedness boundedness() {
            return Boundedness.BOUNDED;
        }
    }

    static class TestingLineageVertex
    implements LineageVertex {
        private final String id;

        private TestingLineageVertex(String id) {
            this.id = id;
        }

        private String id() {
            return this.id;
        }

        public List<LineageDataset> datasets() {
            return new ArrayList<LineageDataset>();
        }
    }
}

