/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table.module;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.state.table.SavepointMetadataTableFunction;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeStrategies;

@Experimental
public class StateModule
implements Module {
    public static final String IDENTIFIER = "state";
    public static final BuiltInFunctionDefinition SAVEPOINT_METADATA = BuiltInFunctionDefinition.newBuilder().name("savepoint_metadata").kind(FunctionKind.TABLE).runtimeClass(SavepointMetadataTableFunction.class.getName()).outputTypeStrategy(TypeStrategies.explicit((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"checkpoint-id", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"operator-name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"operator-uid", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"operator-uid-hash", (DataType)((DataType)DataTypes.STRING().notNull())), DataTypes.FIELD((String)"operator-parallelism", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"operator-max-parallelism", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"operator-subtask-state-count", (DataType)((DataType)DataTypes.INT().notNull())), DataTypes.FIELD((String)"operator-coordinator-state-size-in-bytes", (DataType)((DataType)DataTypes.BIGINT().notNull())), DataTypes.FIELD((String)"operator-total-size-in-bytes", (DataType)((DataType)DataTypes.BIGINT().notNull()))}))).build();
    public static final StateModule INSTANCE = new StateModule();
    private final Map<String, BuiltInFunctionDefinition> normalizedFunctions;
    private final Set<String> functionNamesWithInternal;
    private final Set<String> functionNamesWithoutInternal;

    private StateModule() {
        List<BuiltInFunctionDefinition> definitions = Collections.singletonList(SAVEPOINT_METADATA);
        this.normalizedFunctions = definitions.stream().collect(Collectors.toMap(f -> f.getName().toUpperCase(Locale.ROOT), Function.identity()));
        this.functionNamesWithInternal = definitions.stream().map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
        this.functionNamesWithoutInternal = definitions.stream().filter(f -> !f.isInternal()).map(BuiltInFunctionDefinition::getName).collect(Collectors.toSet());
    }

    public Set<String> listFunctions() {
        return this.listFunctions(false);
    }

    public Set<String> listFunctions(boolean includeHiddenFunctions) {
        if (includeHiddenFunctions) {
            return this.functionNamesWithInternal;
        }
        return this.functionNamesWithoutInternal;
    }

    public Optional<FunctionDefinition> getFunctionDefinition(String name) {
        String normalizedName = name.toUpperCase(Locale.ROOT);
        return Optional.ofNullable((FunctionDefinition)this.normalizedFunctions.get(normalizedName));
    }
}

