/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

@Internal
public final class MultiStateKeyIterator<K>
implements CloseableIterator<K> {
    private final List<? extends StateDescriptor<?, ?>> descriptors;
    private final KeyedStateBackend<K> backend;
    private final Iterator<? extends StateDescriptor<?, ?>> outerIter;
    private Iterator<K> innerIter;
    private final CloseableRegistry registry;
    private K currentKey;

    public MultiStateKeyIterator(List<? extends StateDescriptor<?, ?>> descriptors, KeyedStateBackend<K> backend) {
        this.descriptors = (List)Preconditions.checkNotNull(descriptors);
        this.backend = (KeyedStateBackend)Preconditions.checkNotNull(backend);
        this.outerIter = this.descriptors.iterator();
        this.innerIter = null;
        this.registry = new CloseableRegistry();
    }

    public boolean hasNext() {
        while (this.innerIter == null || !this.innerIter.hasNext()) {
            if (!this.outerIter.hasNext()) {
                return false;
            }
            StateDescriptor<?, ?> descriptor = this.outerIter.next();
            Stream stream = this.backend.getKeys(descriptor.getName(), (Object)VoidNamespace.INSTANCE);
            this.innerIter = stream.iterator();
            try {
                this.registry.registerCloseable(stream::close);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read keys from configured StateBackend", e);
            }
        }
        return true;
    }

    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentKey = this.innerIter.next();
        return this.currentKey;
    }

    public void remove() {
        if (this.currentKey == null) {
            return;
        }
        for (StateDescriptor<?, ?> descriptor : this.descriptors) {
            try {
                State state = this.backend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, descriptor);
                state.clear();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to drop partitioned state from state backend", e);
            }
        }
    }

    public void close() throws Exception {
        this.registry.close();
    }
}

