/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.BroadcastState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.api.functions.BroadcastStateBootstrapFunction;
import org.apache.flink.state.api.output.SnapshotUtils;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class BroadcastStateBootstrapOperator<IN>
extends AbstractUdfStreamOperator<TaggedOperatorSubtaskState, BroadcastStateBootstrapFunction<IN>>
implements OneInputStreamOperator<IN, TaggedOperatorSubtaskState>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final long timestamp;
    private final Path savepointPath;
    private transient ContextImpl context;

    public BroadcastStateBootstrapOperator(long timestamp, Path savepointPath, BroadcastStateBootstrapFunction<IN> function) {
        super(function);
        this.timestamp = timestamp;
        this.savepointPath = savepointPath;
    }

    public void open() throws Exception {
        super.open();
        this.context = new ContextImpl(this.getProcessingTimeService());
    }

    public void processElement(StreamRecord<IN> element) throws Exception {
        ((BroadcastStateBootstrapFunction)this.userFunction).processElement(element.getValue(), this.context);
    }

    public void endInput() throws Exception {
        TaggedOperatorSubtaskState state = SnapshotUtils.snapshot(this, this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask(), this.timestamp, this.getContainingTask().getConfiguration().isExactlyOnceCheckpointMode(), this.getContainingTask().getConfiguration().isUnalignedCheckpointsEnabled(), this.getContainingTask().getConfiguration().getConfiguration(), this.savepointPath);
        this.output.collect((Object)new StreamRecord((Object)state));
    }

    private class ContextImpl
    implements BroadcastStateBootstrapFunction.Context {
        private final ProcessingTimeService processingTimeService;

        ContextImpl(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        @Override
        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        @Override
        public <K, V> BroadcastState<K, V> getBroadcastState(MapStateDescriptor<K, V> descriptor) {
            try {
                return BroadcastStateBootstrapOperator.this.getOperatorStateBackend().getBroadcastState(descriptor);
            }
            catch (Exception e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
    }
}

