/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.PbFormatContext;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializeFactory;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenUtils;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbCodegenMapDeserializer
implements PbCodegenDeserializer {
    private final Descriptors.FieldDescriptor fd;
    private final MapType mapType;
    private final PbFormatContext formatContext;

    public PbCodegenMapDeserializer(Descriptors.FieldDescriptor fd, MapType mapType, PbFormatContext formatContext) {
        this.fd = fd;
        this.mapType = mapType;
        this.formatContext = formatContext;
    }

    @Override
    public String codegen(String resultVar, String pbObjectCode, int indent) throws PbCodegenException {
        PbCodegenVarId varUid = PbCodegenVarId.getInstance();
        int uid = varUid.getAndIncrement();
        LogicalType keyType = this.mapType.getKeyType();
        LogicalType valueType = this.mapType.getValueType();
        Descriptors.FieldDescriptor keyFd = this.fd.getMessageType().findFieldByName("key");
        Descriptors.FieldDescriptor valueFd = this.fd.getMessageType().findFieldByName("value");
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        String pbKeyTypeStr = PbCodegenUtils.getTypeStrFromProto(keyFd, false);
        String pbValueTypeStr = PbCodegenUtils.getTypeStrFromProto(valueFd, false);
        String pbMapVar = "pbMap" + uid;
        String pbMapEntryVar = "pbEntry" + uid;
        String resultDataMapVar = "resultDataMap" + uid;
        String flinkKeyVar = "keyDataVar" + uid;
        String flinkValueVar = "valueDataVar" + uid;
        appender.appendLine("Map<" + pbKeyTypeStr + "," + pbValueTypeStr + "> " + pbMapVar + " = " + pbObjectCode + ";");
        appender.appendLine("Map " + resultDataMapVar + " = new HashMap()");
        appender.begin("for(Map.Entry<" + pbKeyTypeStr + "," + pbValueTypeStr + "> " + pbMapEntryVar + ": " + pbMapVar + ".entrySet()){");
        appender.appendLine("Object " + flinkKeyVar + "= null");
        appender.appendLine("Object " + flinkValueVar + "= null");
        PbCodegenDeserializer keyDes = PbCodegenDeserializeFactory.getPbCodegenDes(keyFd, keyType, this.formatContext);
        PbCodegenDeserializer valueDes = PbCodegenDeserializeFactory.getPbCodegenDes(valueFd, valueType, this.formatContext);
        String keyGenCode = keyDes.codegen(flinkKeyVar, "((" + pbKeyTypeStr + ")" + pbMapEntryVar + ".getKey())", appender.currentIndent());
        appender.appendSegment(keyGenCode);
        String valueGenCode = valueDes.codegen(flinkValueVar, "((" + pbValueTypeStr + ")" + pbMapEntryVar + ".getValue())", appender.currentIndent());
        appender.appendSegment(valueGenCode);
        appender.appendLine(resultDataMapVar + ".put(" + flinkKeyVar + ", " + flinkValueVar + ")");
        appender.end("}");
        appender.appendLine(resultVar + " = new GenericMapData(" + resultDataMapVar + ")");
        return appender.code();
    }
}

