/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;

public class SqlStopJob
extends SqlCall {
    public static final SqlOperator OPERATOR = new SqlSpecialOperator("STOP JOB", SqlKind.OTHER_DDL);
    private final SqlCharStringLiteral jobId;
    private final boolean isWithDrain;
    private final boolean isWithSavepoint;

    public SqlStopJob(SqlParserPos pos, SqlCharStringLiteral jobId, boolean isWithSavepoint, boolean isWithDrain) {
        super(pos);
        this.jobId = jobId;
        this.isWithSavepoint = isWithSavepoint;
        this.isWithDrain = isWithDrain;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("STOP");
        writer.keyword("JOB");
        this.jobId.unparse(writer, leftPrec, rightPrec);
        if (this.isWithSavepoint) {
            writer.keyword("WITH SAVEPOINT");
        }
        if (this.isWithDrain) {
            writer.keyword("WITH DRAIN");
        }
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Nonnull
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.jobId);
    }

    public String getId() {
        return ((NlsString)this.jobId.getValueAs(NlsString.class)).getValue();
    }

    public boolean isWithSavepoint() {
        return this.isWithSavepoint;
    }

    public boolean isWithDrain() {
        return this.isWithDrain;
    }
}

