/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlRichExplain
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EXPLAIN", SqlKind.EXPLAIN);
    private SqlNode statement;
    private final Set<String> explainDetails;

    public SqlRichExplain(SqlParserPos pos, SqlNode statement) {
        this(pos, statement, new HashSet<String>());
    }

    public SqlRichExplain(SqlParserPos pos, SqlNode statement, Set<String> explainDetails) {
        super(pos);
        this.statement = statement;
        this.explainDetails = explainDetails;
    }

    public SqlNode getStatement() {
        return this.statement;
    }

    public SqlOperator getOperator() {
        return OPERATOR;
    }

    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.statement);
    }

    public Set<String> getExplainDetails() {
        return this.explainDetails;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("EXPLAIN");
        if (!this.explainDetails.isEmpty()) {
            writer.keyword(String.join((CharSequence)", ", this.explainDetails));
        }
        this.statement.unparse(writer, leftPrec, rightPrec);
    }

    public void setOperand(int i, SqlNode operand) {
        if (i != 0) {
            throw new UnsupportedOperationException("SqlRichExplain SqlNode only support index equals 0");
        }
        this.statement = operand;
    }
}

