/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlTableLike;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateTableLike
extends SqlCreateTable {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE LIKE", SqlKind.CREATE_TABLE);
    private final SqlTableLike tableLike;

    public SqlCreateTableLike(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, SqlTableLike tableLike, boolean isTemporary, boolean ifNotExists) {
        super(OPERATOR, pos, tableName, columnList, tableConstraints, propertyList, partitionKeyList, watermark, comment, isTemporary, ifNotExists);
        this.tableLike = Objects.requireNonNull(tableLike, "LIKE clause is required for CREATE TABLE LIKE DDL");
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.builder().addAll(super.getOperandList()).add((Object)this.tableLike).build();
    }

    @Override
    public void validate() throws SqlValidateException {
        super.validate();
        this.tableLike.validate();
    }

    public SqlTableLike getTableLike() {
        return this.tableLike;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.newlineAndIndent();
        this.tableLike.unparse(writer, leftPrec, rightPrec);
    }
}

