/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Arrays;
import java.util.Locale;
import org.apache.flink.annotation.Internal;
import org.apache.flink.types.variant.Variant;
import org.apache.flink.types.variant.VariantTypeException;

@Internal
public class BinaryVariantUtil {
    public static final int BASIC_TYPE_BITS = 2;
    public static final int BASIC_TYPE_MASK = 3;
    public static final int TYPE_INFO_MASK = 63;
    public static final int MAX_SHORT_STR_SIZE = 63;
    public static final int PRIMITIVE = 0;
    public static final int SHORT_STR = 1;
    public static final int OBJECT = 2;
    public static final int ARRAY = 3;
    public static final int NULL = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int INT1 = 3;
    public static final int INT2 = 4;
    public static final int INT4 = 5;
    public static final int INT8 = 6;
    public static final int DOUBLE = 7;
    public static final int DECIMAL4 = 8;
    public static final int DECIMAL8 = 9;
    public static final int DECIMAL16 = 10;
    public static final int DATE = 11;
    public static final int TIMESTAMP_LTZ = 12;
    public static final int TIMESTAMP = 13;
    public static final int FLOAT = 14;
    public static final int BINARY = 15;
    public static final int LONG_STR = 16;
    public static final byte VERSION = 1;
    public static final byte VERSION_MASK = 15;
    public static final int U8_MAX = 255;
    public static final int U16_MAX = 65535;
    public static final int U24_MAX = 0xFFFFFF;
    public static final int U24_SIZE = 3;
    public static final int U32_SIZE = 4;
    public static final int SIZE_LIMIT = 0x1000000;
    public static final int MAX_DECIMAL4_PRECISION = 9;
    public static final int MAX_DECIMAL8_PRECISION = 18;
    public static final int MAX_DECIMAL16_PRECISION = 38;
    public static final int BINARY_SEARCH_THRESHOLD = 32;
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter(Locale.US);
    public static final DateTimeFormatter TIMESTAMP_LTZ_FORMATTER = new DateTimeFormatterBuilder().append(TIMESTAMP_FORMATTER).appendOffset("+HH:MM", "+00:00").toFormatter(Locale.US);

    public static void writeLong(byte[] bytes, int pos, long value, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            bytes[pos + i] = (byte)(value >>> 8 * i & 0xFFL);
        }
    }

    public static byte primitiveHeader(int type) {
        return (byte)(type << 2 | 0);
    }

    public static byte shortStrHeader(int size) {
        return (byte)(size << 2 | 1);
    }

    public static byte objectHeader(boolean largeSize, int idSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 6 | idSize - 1 << 4 | offsetSize - 1 << 2 | 2);
    }

    public static byte arrayHeader(boolean largeSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 4 | offsetSize - 1 << 2 | 3);
    }

    static VariantTypeException malformedVariant() {
        return new VariantTypeException("MALFORMED_VARIANT");
    }

    static VariantTypeException unknownPrimitiveTypeInVariant(int id) {
        return new VariantTypeException("UNKNOWN_PRIMITIVE_TYPE_IN_VARIANT, id: " + id);
    }

    static VariantTypeException variantConstructorSizeLimit() {
        return new VariantTypeException("VARIANT_CONSTRUCTOR_SIZE_LIMIT");
    }

    static void checkIndex(int pos, int length) {
        if (pos < 0 || pos >= length) {
            throw BinaryVariantUtil.malformedVariant();
        }
    }

    static long readLong(byte[] bytes, int pos, int numBytes) {
        BinaryVariantUtil.checkIndex(pos, bytes.length);
        BinaryVariantUtil.checkIndex(pos + numBytes - 1, bytes.length);
        long result = 0L;
        for (int i = 0; i < numBytes - 1; ++i) {
            long unsignedByteValue = bytes[pos + i] & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        long signedByteValue = bytes[pos + numBytes - 1];
        return result |= signedByteValue << 8 * (numBytes - 1);
    }

    static int readUnsigned(byte[] bytes, int pos, int numBytes) {
        BinaryVariantUtil.checkIndex(pos, bytes.length);
        BinaryVariantUtil.checkIndex(pos + numBytes - 1, bytes.length);
        int result = 0;
        for (int i = 0; i < numBytes; ++i) {
            int unsignedByteValue = bytes[pos + i] & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        if (result < 0) {
            throw BinaryVariantUtil.malformedVariant();
        }
        return result;
    }

    public static int getTypeInfo(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        return value[pos] >> 2 & 0x3F;
    }

    public static Variant.Type getType(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        switch (basicType) {
            case 1: {
                return Variant.Type.STRING;
            }
            case 2: {
                return Variant.Type.OBJECT;
            }
            case 3: {
                return Variant.Type.ARRAY;
            }
        }
        switch (typeInfo) {
            case 0: {
                return Variant.Type.NULL;
            }
            case 1: 
            case 2: {
                return Variant.Type.BOOLEAN;
            }
            case 3: {
                return Variant.Type.TINYINT;
            }
            case 4: {
                return Variant.Type.SMALLINT;
            }
            case 5: {
                return Variant.Type.INT;
            }
            case 6: {
                return Variant.Type.BIGINT;
            }
            case 7: {
                return Variant.Type.DOUBLE;
            }
            case 8: 
            case 9: 
            case 10: {
                return Variant.Type.DECIMAL;
            }
            case 11: {
                return Variant.Type.DATE;
            }
            case 12: {
                return Variant.Type.TIMESTAMP_LTZ;
            }
            case 13: {
                return Variant.Type.TIMESTAMP;
            }
            case 14: {
                return Variant.Type.FLOAT;
            }
            case 15: {
                return Variant.Type.BYTES;
            }
            case 16: {
                return Variant.Type.STRING;
            }
        }
        throw BinaryVariantUtil.unknownPrimitiveTypeInVariant(typeInfo);
    }

    public static int valueSize(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        switch (basicType) {
            case 1: {
                return 1 + typeInfo;
            }
            case 2: {
                return BinaryVariantUtil.handleObject(value, pos, (size, idSize, offsetSize, idStart, offsetStart, dataStart) -> dataStart - pos + BinaryVariantUtil.readUnsigned(value, offsetStart + size * offsetSize, offsetSize));
            }
            case 3: {
                return BinaryVariantUtil.handleArray(value, pos, (size, offsetSize, offsetStart, dataStart) -> dataStart - pos + BinaryVariantUtil.readUnsigned(value, offsetStart + size * offsetSize, offsetSize));
            }
        }
        switch (typeInfo) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: 
            case 11: 
            case 14: {
                return 5;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                return 9;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 18;
            }
            case 15: 
            case 16: {
                return 5 + BinaryVariantUtil.readUnsigned(value, pos + 1, 4);
            }
        }
        throw BinaryVariantUtil.unknownPrimitiveTypeInVariant(typeInfo);
    }

    static VariantTypeException unexpectedType(Variant.Type type) {
        return new VariantTypeException("Expect type to be " + String.valueOf((Object)type));
    }

    public static boolean getBoolean(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 1 && typeInfo != 2) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.BOOLEAN);
        }
        return typeInfo == 1;
    }

    public static long getLong(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        String exceptionMessage = "Expect type to be LONG/DATE/TIMESTAMP/TIMESTAMP_LTZ";
        if (basicType != 0) {
            throw new IllegalStateException(exceptionMessage);
        }
        switch (typeInfo) {
            case 3: {
                return BinaryVariantUtil.readLong(value, pos + 1, 1);
            }
            case 4: {
                return BinaryVariantUtil.readLong(value, pos + 1, 2);
            }
            case 5: 
            case 11: {
                return BinaryVariantUtil.readLong(value, pos + 1, 4);
            }
            case 6: 
            case 12: 
            case 13: {
                return BinaryVariantUtil.readLong(value, pos + 1, 8);
            }
        }
        throw new IllegalStateException(exceptionMessage);
    }

    public static double getDouble(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 7) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.DOUBLE);
        }
        return Double.longBitsToDouble(BinaryVariantUtil.readLong(value, pos + 1, 8));
    }

    private static void checkDecimal(BigDecimal d, int maxPrecision) {
        if (d.precision() > maxPrecision || d.scale() > maxPrecision) {
            throw BinaryVariantUtil.malformedVariant();
        }
    }

    public static BigDecimal getDecimalWithOriginalScale(byte[] value, int pos) {
        BigDecimal result;
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.DECIMAL);
        }
        int scale = value[pos + 1] & 0xFF;
        switch (typeInfo) {
            case 8: {
                result = BigDecimal.valueOf(BinaryVariantUtil.readLong(value, pos + 2, 4), scale);
                BinaryVariantUtil.checkDecimal(result, 9);
                break;
            }
            case 9: {
                result = BigDecimal.valueOf(BinaryVariantUtil.readLong(value, pos + 2, 8), scale);
                BinaryVariantUtil.checkDecimal(result, 18);
                break;
            }
            case 10: {
                BinaryVariantUtil.checkIndex(pos + 17, value.length);
                byte[] bytes = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    bytes[i] = value[pos + 17 - i];
                }
                result = new BigDecimal(new BigInteger(bytes), scale);
                BinaryVariantUtil.checkDecimal(result, 38);
                break;
            }
            default: {
                throw BinaryVariantUtil.unexpectedType(Variant.Type.DECIMAL);
            }
        }
        return result;
    }

    public static BigDecimal getDecimal(byte[] value, int pos) {
        return BinaryVariantUtil.getDecimalWithOriginalScale(value, pos).stripTrailingZeros();
    }

    public static float getFloat(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 14) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.FLOAT);
        }
        return Float.intBitsToFloat((int)BinaryVariantUtil.readLong(value, pos + 1, 4));
    }

    public static byte[] getBinary(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 15) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.BYTES);
        }
        int start = pos + 1 + 4;
        int length = BinaryVariantUtil.readUnsigned(value, pos + 1, 4);
        BinaryVariantUtil.checkIndex(start + length - 1, value.length);
        return Arrays.copyOfRange(value, start, start + length);
    }

    public static String getString(byte[] value, int pos) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType == 1 || basicType == 0 && typeInfo == 16) {
            int length;
            int start;
            if (basicType == 1) {
                start = pos + 1;
                length = typeInfo;
            } else {
                start = pos + 1 + 4;
                length = BinaryVariantUtil.readUnsigned(value, pos + 1, 4);
            }
            BinaryVariantUtil.checkIndex(start + length - 1, value.length);
            return new String(value, start, length);
        }
        throw BinaryVariantUtil.unexpectedType(Variant.Type.STRING);
    }

    public static <T> T handleObject(byte[] value, int pos, ObjectHandler<T> handler) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 2) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.OBJECT);
        }
        boolean largeSize = (typeInfo >> 4 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int size = BinaryVariantUtil.readUnsigned(value, pos + 1, sizeBytes);
        int idSize = (typeInfo >> 2 & 3) + 1;
        int offsetSize = (typeInfo & 3) + 1;
        int idStart = pos + 1 + sizeBytes;
        int offsetStart = idStart + size * idSize;
        int dataStart = offsetStart + (size + 1) * offsetSize;
        return handler.apply(size, idSize, offsetSize, idStart, offsetStart, dataStart);
    }

    public static <T> T handleArray(byte[] value, int pos, ArrayHandler<T> handler) {
        BinaryVariantUtil.checkIndex(pos, value.length);
        int basicType = value[pos] & 3;
        int typeInfo = value[pos] >> 2 & 0x3F;
        if (basicType != 3) {
            throw BinaryVariantUtil.unexpectedType(Variant.Type.ARRAY);
        }
        boolean largeSize = (typeInfo >> 2 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int size = BinaryVariantUtil.readUnsigned(value, pos + 1, sizeBytes);
        int offsetSize = (typeInfo & 3) + 1;
        int offsetStart = pos + 1 + sizeBytes;
        int dataStart = offsetStart + (size + 1) * offsetSize;
        return handler.apply(size, offsetSize, offsetStart, dataStart);
    }

    public static String getMetadataKey(byte[] metadata, int id) {
        int nextOffset;
        BinaryVariantUtil.checkIndex(0, metadata.length);
        int offsetSize = (metadata[0] >> 6 & 3) + 1;
        int dictSize = BinaryVariantUtil.readUnsigned(metadata, 1, offsetSize);
        if (id >= dictSize) {
            throw BinaryVariantUtil.malformedVariant();
        }
        int stringStart = 1 + (dictSize + 2) * offsetSize;
        int offset = BinaryVariantUtil.readUnsigned(metadata, 1 + (id + 1) * offsetSize, offsetSize);
        if (offset > (nextOffset = BinaryVariantUtil.readUnsigned(metadata, 1 + (id + 2) * offsetSize, offsetSize))) {
            throw BinaryVariantUtil.malformedVariant();
        }
        BinaryVariantUtil.checkIndex(stringStart + nextOffset - 1, metadata.length);
        return new String(metadata, stringStart + offset, nextOffset - offset);
    }

    public static interface ArrayHandler<T> {
        public T apply(int var1, int var2, int var3, int var4);
    }

    public static interface ObjectHandler<T> {
        public T apply(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

