/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.session;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.session.ConfigureSessionRequestBody;
import org.apache.flink.table.gateway.rest.message.session.SessionHandleIdPathParameter;
import org.apache.flink.table.gateway.rest.message.session.SessionMessageParameters;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class ConfigureSessionHandler
extends AbstractSqlGatewayRestHandler<ConfigureSessionRequestBody, EmptyResponseBody, SessionMessageParameters> {
    public ConfigureSessionHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<ConfigureSessionRequestBody, EmptyResponseBody, SessionMessageParameters> messageHeaders) {
        super(service, responseHeaders, messageHeaders);
    }

    @Override
    protected CompletableFuture<EmptyResponseBody> handleRequest(SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<ConfigureSessionRequestBody> request) throws RestHandlerException {
        SessionHandle sessionHandle = (SessionHandle)request.getPathParameter(SessionHandleIdPathParameter.class);
        String statement = request.getRequestBody().getStatement();
        Long timeout = request.getRequestBody().getTimeout();
        timeout = timeout == null ? 0L : timeout;
        this.service.configureSession(sessionHandle, statement, timeout);
        return CompletableFuture.completedFuture(EmptyResponseBody.getInstance());
    }
}

