/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.ModelAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.ModelNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionAlreadyExistsException;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.exceptions.PartitionSpecInvalidException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotPartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class GenericInMemoryCatalog
extends AbstractCatalog {
    public static final String DEFAULT_DB = "default";
    private final Map<String, CatalogDatabase> databases = new LinkedHashMap<String, CatalogDatabase>();
    private final Map<ObjectPath, CatalogBaseTable> tables;
    private final Map<ObjectPath, CatalogModel> models;
    private final Map<ObjectPath, CatalogFunction> functions;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogPartition>> partitions;
    private final Map<ObjectPath, CatalogTableStatistics> tableStats;
    private final Map<ObjectPath, CatalogColumnStatistics> tableColumnStats;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogTableStatistics>> partitionStats;
    private final Map<ObjectPath, Map<CatalogPartitionSpec, CatalogColumnStatistics>> partitionColumnStats;

    public GenericInMemoryCatalog(String name) {
        this(name, DEFAULT_DB);
    }

    public GenericInMemoryCatalog(String name, String defaultDatabase) {
        super(name, defaultDatabase);
        this.databases.put(defaultDatabase, new CatalogDatabaseImpl(new HashMap<String, String>(), null));
        this.tables = new LinkedHashMap<ObjectPath, CatalogBaseTable>();
        this.models = new LinkedHashMap<ObjectPath, CatalogModel>();
        this.functions = new LinkedHashMap<ObjectPath, CatalogFunction>();
        this.partitions = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogPartition>>();
        this.tableStats = new LinkedHashMap<ObjectPath, CatalogTableStatistics>();
        this.tableColumnStats = new LinkedHashMap<ObjectPath, CatalogColumnStatistics>();
        this.partitionStats = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogTableStatistics>>();
        this.partitionColumnStats = new LinkedHashMap<ObjectPath, Map<CatalogPartitionSpec, CatalogColumnStatistics>>();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void createDatabase(String databaseName, CatalogDatabase db, boolean ignoreIfExists) throws DatabaseAlreadyExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        Preconditions.checkNotNull(db);
        if (this.databaseExists(databaseName)) {
            if (!ignoreIfExists) {
                throw new DatabaseAlreadyExistException(this.getName(), databaseName);
            }
        } else {
            this.databases.put(databaseName, db.copy());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dropDatabase(String databaseName, boolean ignoreIfNotExists, boolean cascade) throws DatabaseNotExistException, DatabaseNotEmptyException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        if (this.databases.containsKey(databaseName)) {
            if (this.isDatabaseEmpty(databaseName)) {
                this.databases.remove(databaseName);
                return;
            } else {
                if (!cascade) throw new DatabaseNotEmptyException(this.getName(), databaseName);
                List<ObjectPath> deleteTablePaths = this.tables.keySet().stream().filter(op -> op.getDatabaseName().equals(databaseName)).collect(Collectors.toList());
                deleteTablePaths.forEach(objectPath -> {
                    try {
                        this.dropTable((ObjectPath)objectPath, true);
                    }
                    catch (TableNotExistException tableNotExistException) {
                        // empty catch block
                    }
                });
                List<ObjectPath> deleteFunctionPaths = this.functions.keySet().stream().filter(op -> op.getDatabaseName().equals(databaseName)).collect(Collectors.toList());
                deleteFunctionPaths.forEach(objectPath -> {
                    try {
                        this.dropFunction((ObjectPath)objectPath, true);
                    }
                    catch (FunctionNotExistException functionNotExistException) {
                        // empty catch block
                    }
                });
                this.databases.remove(databaseName);
            }
            return;
        } else {
            if (ignoreIfNotExists) return;
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
    }

    private boolean isDatabaseEmpty(String databaseName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        return this.tables.keySet().stream().noneMatch(op -> op.getDatabaseName().equals(databaseName)) && this.functions.keySet().stream().noneMatch(op -> op.getDatabaseName().equals(databaseName));
    }

    @Override
    public void alterDatabase(String databaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        Preconditions.checkNotNull(newDatabase);
        CatalogDatabase existingDatabase = this.databases.get(databaseName);
        if (existingDatabase != null) {
            if (existingDatabase.getClass() != newDatabase.getClass()) {
                throw new CatalogException(String.format("Database types don't match. Existing database is '%s' and new database is '%s'.", existingDatabase.getClass().getName(), newDatabase.getClass().getName()));
            }
            this.databases.put(databaseName, newDatabase.copy());
        } else if (!ignoreIfNotExists) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
    }

    @Override
    public List<String> listDatabases() {
        return new ArrayList<String>(this.databases.keySet());
    }

    @Override
    public CatalogDatabase getDatabase(String databaseName) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return this.databases.get(databaseName).copy();
    }

    @Override
    public boolean databaseExists(String databaseName) {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName));
        return this.databases.containsKey(databaseName);
    }

    @Override
    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(table);
        if (!this.databaseExists(tablePath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), tablePath.getDatabaseName());
        }
        if (this.tableExists(tablePath)) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.getName(), tablePath);
            }
        } else {
            this.tables.put(tablePath, table.copy());
            if (this.isPartitionedTable(tablePath)) {
                this.partitions.put(tablePath, new LinkedHashMap());
                this.partitionStats.put(tablePath, new LinkedHashMap());
                this.partitionColumnStats.put(tablePath, new LinkedHashMap());
            }
        }
    }

    @Override
    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(newTable);
        CatalogBaseTable existingTable = this.tables.get(tablePath);
        if (existingTable != null) {
            if (existingTable.getTableKind() != newTable.getTableKind()) {
                throw new CatalogException(String.format("Table types don't match. Existing table is '%s' and new table is '%s'.", new Object[]{existingTable.getTableKind(), newTable.getTableKind()}));
            }
            this.tables.put(tablePath, newTable.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        if (this.tableExists(tablePath)) {
            this.tables.remove(tablePath);
            this.tableStats.remove(tablePath);
            this.tableColumnStats.remove(tablePath);
            this.partitions.remove(tablePath);
            this.partitionStats.remove(tablePath);
            this.partitionColumnStats.remove(tablePath);
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws TableNotExistException, TableAlreadyExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(newTableName));
        if (this.tableExists(tablePath)) {
            ObjectPath newPath = new ObjectPath(tablePath.getDatabaseName(), newTableName);
            if (this.tableExists(newPath)) {
                throw new TableAlreadyExistException(this.getName(), newPath);
            }
            this.tables.put(newPath, this.tables.remove(tablePath));
            if (this.tableStats.containsKey(tablePath)) {
                this.tableStats.put(newPath, this.tableStats.remove(tablePath));
            }
            if (this.tableColumnStats.containsKey(tablePath)) {
                this.tableColumnStats.put(newPath, this.tableColumnStats.remove(tablePath));
            }
            if (this.partitions.containsKey(tablePath)) {
                this.partitions.put(newPath, this.partitions.remove(tablePath));
            }
            if (this.partitionStats.containsKey(tablePath)) {
                this.partitionStats.put(newPath, this.partitionStats.remove(tablePath));
            }
            if (this.partitionColumnStats.containsKey(tablePath)) {
                this.partitionColumnStats.put(newPath, this.partitionColumnStats.remove(tablePath));
            }
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public List<String> listTables(String databaseName) throws DatabaseNotExistException {
        return this.listObjectsUnderDatabase(this.tables, databaseName, objectPath -> true);
    }

    @Override
    public List<String> listViews(String databaseName) throws DatabaseNotExistException {
        return this.listObjectsUnderDatabase(this.tables, databaseName, k -> this.tables.get(k) instanceof CatalogView);
    }

    @Override
    public List<String> listMaterializedTables(String databaseName) throws DatabaseNotExistException {
        return this.listObjectsUnderDatabase(this.tables, databaseName, k -> this.tables.get(k) instanceof CatalogMaterializedTable);
    }

    @Override
    public CatalogBaseTable getTable(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        return this.tables.get(tablePath).copy();
    }

    @Override
    public boolean tableExists(ObjectPath tablePath) {
        Preconditions.checkNotNull(tablePath);
        return this.databaseExists(tablePath.getDatabaseName()) && this.tables.containsKey(tablePath);
    }

    private void ensureTableExists(ObjectPath tablePath) throws TableNotExistException {
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public void createModel(ObjectPath modelPath, CatalogModel model, boolean ignoreIfExists) throws ModelAlreadyExistException, DatabaseNotExistException {
        Preconditions.checkNotNull(modelPath);
        Preconditions.checkNotNull(model);
        if (!this.databaseExists(modelPath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), modelPath.getDatabaseName());
        }
        if (this.modelExists(modelPath)) {
            if (!ignoreIfExists) {
                throw new ModelAlreadyExistException(this.getName(), modelPath);
            }
        } else {
            this.models.put(modelPath, model.copy());
        }
    }

    @Override
    public void alterModel(ObjectPath modelPath, CatalogModel newModel, boolean ignoreIfNotExists) throws ModelNotExistException {
        Preconditions.checkNotNull(modelPath);
        CatalogModel existingModel = this.models.get(modelPath);
        if (existingModel == null || newModel == null) {
            if (ignoreIfNotExists) {
                return;
            }
            throw new ModelNotExistException(this.getName(), modelPath);
        }
        this.models.put(modelPath, newModel.copy());
    }

    @Override
    public void dropModel(ObjectPath modelPath, boolean ignoreIfNotExists) throws ModelNotExistException {
        Preconditions.checkNotNull(modelPath);
        if (this.modelExists(modelPath)) {
            this.models.remove(modelPath);
        } else if (!ignoreIfNotExists) {
            throw new ModelNotExistException(this.getName(), modelPath);
        }
    }

    @Override
    public void renameModel(ObjectPath modelPath, String newModelName, boolean ignoreIfNotExists) throws ModelNotExistException, ModelAlreadyExistException {
        Preconditions.checkNotNull(modelPath);
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(newModelName));
        if (this.modelExists(modelPath)) {
            ObjectPath newPath = new ObjectPath(modelPath.getDatabaseName(), newModelName);
            if (this.modelExists(newPath)) {
                throw new ModelAlreadyExistException(this.getName(), newPath);
            }
            this.models.put(newPath, this.models.remove(modelPath));
        } else if (!ignoreIfNotExists) {
            throw new ModelNotExistException(this.getName(), modelPath);
        }
    }

    @Override
    public List<String> listModels(String databaseName) throws DatabaseNotExistException {
        return this.listObjectsUnderDatabase(this.models, databaseName, k -> true);
    }

    @Override
    public CatalogModel getModel(ObjectPath modelPath) throws ModelNotExistException {
        Preconditions.checkNotNull(modelPath);
        if (!this.modelExists(modelPath)) {
            throw new ModelNotExistException(this.getName(), modelPath);
        }
        return this.models.get(modelPath).copy();
    }

    @Override
    public boolean modelExists(ObjectPath modelPath) {
        Preconditions.checkNotNull(modelPath);
        return this.databaseExists(modelPath.getDatabaseName()) && this.models.containsKey(modelPath);
    }

    @Override
    public void createFunction(ObjectPath path, CatalogFunction function, boolean ignoreIfExists) throws FunctionAlreadyExistException, DatabaseNotExistException {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(function);
        ObjectPath functionPath = this.normalize(path);
        if (!this.databaseExists(functionPath.getDatabaseName())) {
            throw new DatabaseNotExistException(this.getName(), functionPath.getDatabaseName());
        }
        if (this.functionExists(functionPath)) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistException(this.getName(), functionPath);
            }
        } else {
            this.functions.put(functionPath, function.copy());
        }
    }

    @Override
    public void alterFunction(ObjectPath path, CatalogFunction newFunction, boolean ignoreIfNotExists) throws FunctionNotExistException {
        Preconditions.checkNotNull(path);
        Preconditions.checkNotNull(newFunction);
        ObjectPath functionPath = this.normalize(path);
        CatalogFunction existingFunction = this.functions.get(functionPath);
        if (existingFunction != null) {
            if (existingFunction.getClass() != newFunction.getClass()) {
                throw new CatalogException(String.format("Function types don't match. Existing function is '%s' and new function is '%s'.", existingFunction.getClass().getName(), newFunction.getClass().getName()));
            }
            this.functions.put(functionPath, newFunction.copy());
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
    }

    @Override
    public void dropFunction(ObjectPath path, boolean ignoreIfNotExists) throws FunctionNotExistException {
        Preconditions.checkNotNull(path);
        ObjectPath functionPath = this.normalize(path);
        if (this.functionExists(functionPath)) {
            this.functions.remove(functionPath);
        } else if (!ignoreIfNotExists) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
    }

    @Override
    public List<String> listFunctions(String databaseName) throws DatabaseNotExistException {
        return this.listObjectsUnderDatabase(this.functions, databaseName, k -> true);
    }

    @Override
    public CatalogFunction getFunction(ObjectPath path) throws FunctionNotExistException {
        Preconditions.checkNotNull(path);
        ObjectPath functionPath = this.normalize(path);
        if (!this.databaseExists(functionPath.getDatabaseName()) || !this.functions.containsKey(functionPath)) {
            throw new FunctionNotExistException(this.getName(), functionPath);
        }
        return this.functions.get(functionPath).copy();
    }

    @Override
    public boolean functionExists(ObjectPath path) {
        Preconditions.checkNotNull(path);
        try {
            this.getFunction(path);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ObjectPath normalize(ObjectPath path) {
        return new ObjectPath(path.getDatabaseName(), FunctionIdentifier.normalizeName(path.getObjectName()));
    }

    @Override
    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, PartitionAlreadyExistsException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        Preconditions.checkNotNull(partition);
        this.ensureTableExists(tablePath);
        this.ensurePartitionedTable(tablePath);
        this.ensureFullPartitionSpec(tablePath, partitionSpec);
        if (this.partitionExists(tablePath, partitionSpec) && !ignoreIfExists) {
            throw new PartitionAlreadyExistsException(this.getName(), tablePath, partitionSpec);
        }
        this.partitions.get(tablePath).put(partitionSpec, partition.copy());
    }

    @Override
    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitions.get(tablePath).remove(partitionSpec);
            this.partitionStats.get(tablePath).remove(partitionSpec);
            this.partitionColumnStats.get(tablePath).remove(partitionSpec);
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    @Override
    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        Preconditions.checkNotNull(newPartition);
        if (this.partitionExists(tablePath, partitionSpec)) {
            CatalogPartition existingPartition = this.partitions.get(tablePath).get(partitionSpec);
            if (existingPartition.getClass() != newPartition.getClass()) {
                throw new CatalogException(String.format("Partition types don't match. Existing partition is '%s' and new partition is '%s'.", existingPartition.getClass().getName(), newPartition.getClass().getName()));
            }
            this.partitions.get(tablePath).put(partitionSpec, newPartition.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    @Override
    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        this.ensureTableExists(tablePath);
        this.ensurePartitionedTable(tablePath);
        return new ArrayList<CatalogPartitionSpec>(this.partitions.get(tablePath).keySet());
    }

    @Override
    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, TableNotPartitionedException, PartitionSpecInvalidException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        this.ensurePartitionedTable(tablePath);
        CatalogTable catalogTable = (CatalogTable)this.getTable(tablePath);
        List<String> partKeys = catalogTable.getPartitionKeys();
        Map<String, String> spec = partitionSpec.getPartitionSpec();
        if (!partKeys.containsAll(spec.keySet())) {
            return new ArrayList<CatalogPartitionSpec>();
        }
        return this.partitions.get(tablePath).keySet().stream().filter(ps -> ps.getPartitionSpec().entrySet().containsAll(partitionSpec.getPartitionSpec().entrySet())).collect(Collectors.toList());
    }

    @Override
    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws TableNotExistException, TableNotPartitionedException, CatalogException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException, CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        return this.partitions.get(tablePath).get(partitionSpec).copy();
    }

    @Override
    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        return this.partitions.containsKey(tablePath) && this.partitions.get(tablePath).containsKey(partitionSpec);
    }

    private void ensureFullPartitionSpec(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException, PartitionSpecInvalidException {
        if (!this.isFullPartitionSpec(tablePath, partitionSpec)) {
            throw new PartitionSpecInvalidException(this.getName(), ((CatalogTable)this.getTable(tablePath)).getPartitionKeys(), tablePath, partitionSpec);
        }
    }

    private boolean isFullPartitionSpec(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws TableNotExistException {
        CatalogBaseTable baseTable = this.getTable(tablePath);
        if (!(baseTable instanceof CatalogTable)) {
            return false;
        }
        CatalogTable table = (CatalogTable)baseTable;
        List<String> partitionKeys = table.getPartitionKeys();
        Map<String, String> spec = partitionSpec.getPartitionSpec();
        return partitionKeys.size() == spec.size() && spec.keySet().containsAll(partitionKeys);
    }

    private void ensurePartitionedTable(ObjectPath tablePath) throws TableNotPartitionedException {
        if (!this.isPartitionedTable(tablePath)) {
            throw new TableNotPartitionedException(this.getName(), tablePath);
        }
    }

    private boolean isPartitionedTable(ObjectPath tablePath) {
        CatalogBaseTable table = null;
        try {
            table = this.getTable(tablePath);
        }
        catch (TableNotExistException e) {
            return false;
        }
        return table instanceof CatalogTable && ((CatalogTable)table).isPartitioned();
    }

    @Override
    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        if (!this.isPartitionedTable(tablePath)) {
            CatalogTableStatistics result = this.tableStats.get(tablePath);
            return result != null ? result.copy() : CatalogTableStatistics.UNKNOWN;
        }
        return CatalogTableStatistics.UNKNOWN;
    }

    @Override
    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        if (!this.tableExists(tablePath)) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
        CatalogColumnStatistics result = this.tableColumnStats.get(tablePath);
        return result != null ? result.copy() : CatalogColumnStatistics.UNKNOWN;
    }

    @Override
    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        CatalogTableStatistics result = this.partitionStats.get(tablePath).get(partitionSpec);
        return result != null ? result.copy() : CatalogTableStatistics.UNKNOWN;
    }

    @Override
    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws PartitionNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        if (!this.partitionExists(tablePath, partitionSpec)) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
        CatalogColumnStatistics result = this.partitionColumnStats.get(tablePath).get(partitionSpec);
        return result != null ? result.copy() : CatalogColumnStatistics.UNKNOWN;
    }

    @Override
    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(tableStatistics);
        if (this.tableExists(tablePath)) {
            this.tableStats.put(tablePath, tableStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws TableNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(columnStatistics);
        if (this.tableExists(tablePath)) {
            this.tableColumnStats.put(tablePath, columnStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new TableNotExistException(this.getName(), tablePath);
        }
    }

    @Override
    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        Preconditions.checkNotNull(partitionStatistics);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitionStats.get(tablePath).put(partitionSpec, partitionStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    @Override
    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws PartitionNotExistException {
        Preconditions.checkNotNull(tablePath);
        Preconditions.checkNotNull(partitionSpec);
        Preconditions.checkNotNull(columnStatistics);
        if (this.partitionExists(tablePath, partitionSpec)) {
            this.partitionColumnStats.get(tablePath).put(partitionSpec, columnStatistics.copy());
        } else if (!ignoreIfNotExists) {
            throw new PartitionNotExistException(this.getName(), tablePath, partitionSpec);
        }
    }

    private List<String> listObjectsUnderDatabase(Map<ObjectPath, ?> map, String databaseName, Predicate<ObjectPath> filter) throws DatabaseNotExistException {
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(databaseName), "databaseName cannot be null or empty");
        if (!this.databaseExists(databaseName)) {
            throw new DatabaseNotExistException(this.getName(), databaseName);
        }
        return map.keySet().stream().filter(k -> k.getDatabaseName().equals(databaseName)).filter(filter).map(ObjectPath::getObjectName).collect(Collectors.toList());
    }
}

