/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.FunctionDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ContextResolvedFunction;
import org.apache.flink.table.catalog.ContextResolvedProcedure;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.TemporaryOperationListener;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.ProcedureNotExistException;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public final class FunctionCatalog {
    private final ReadableConfig config;
    private final ResourceManager resourceManager;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    private final Map<String, CatalogFunction> tempSystemFunctions;
    private final Map<ObjectIdentifier, CatalogFunction> tempCatalogFunctions;

    public FunctionCatalog(ReadableConfig config, ResourceManager resourceManager, CatalogManager catalogManager, ModuleManager moduleManager) {
        this(config, resourceManager, catalogManager, moduleManager, new LinkedHashMap<String, CatalogFunction>(), new LinkedHashMap<ObjectIdentifier, CatalogFunction>());
    }

    private FunctionCatalog(ReadableConfig config, ResourceManager resourceManager, CatalogManager catalogManager, ModuleManager moduleManager, Map<String, CatalogFunction> tempSystemFunctions, Map<ObjectIdentifier, CatalogFunction> tempCatalogFunctions) {
        this.config = Preconditions.checkNotNull(config);
        this.resourceManager = Preconditions.checkNotNull(resourceManager);
        this.catalogManager = Preconditions.checkNotNull(catalogManager);
        this.moduleManager = Preconditions.checkNotNull(moduleManager);
        this.tempSystemFunctions = tempSystemFunctions;
        this.tempCatalogFunctions = tempCatalogFunctions;
    }

    public void registerTemporarySystemFunction(String name, FunctionDefinition definition, boolean ignoreIfExists) {
        this.registerTemporarySystemFunction(name, new InlineCatalogFunction(definition), ignoreIfExists);
    }

    public void registerTemporarySystemFunction(String name, FunctionDescriptor functionDescriptor, boolean ignoreIfExists) {
        this.registerTemporarySystemFunction(name, new CatalogFunctionImpl(functionDescriptor.getClassName(), functionDescriptor.getLanguage(), functionDescriptor.getResourceUris(), functionDescriptor.getOptions()), ignoreIfExists);
    }

    public boolean dropTemporarySystemFunction(String name, boolean ignoreIfNotExist) {
        String normalizedName = FunctionIdentifier.normalizeName(name);
        CatalogFunction function = this.tempSystemFunctions.remove(normalizedName);
        if (function == null && !ignoreIfNotExist) {
            throw new ValidationException(String.format("Could not drop temporary system function. A function named '%s' doesn't exist.", name));
        }
        this.unregisterFunctionJarResources(function);
        return function != null;
    }

    private void unregisterFunctionJarResources(@Nullable CatalogFunction function) {
        if (function != null && function.getFunctionLanguage() == FunctionLanguage.JAVA) {
            this.resourceManager.unregisterFunctionResources(function.getFunctionResources());
        }
    }

    public void registerTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, FunctionDefinition definition, boolean ignoreIfExists) {
        this.registerTemporaryCatalogFunction(unresolvedIdentifier, new InlineCatalogFunction(definition), ignoreIfExists);
    }

    public void registerTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, CatalogFunction catalogFunction, boolean ignoreIfExists) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier(identifier);
        if (!this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            Optional<TemporaryOperationListener> listener = this.catalogManager.getTemporaryOperationListener(normalizedIdentifier);
            if (listener.isPresent()) {
                catalogFunction = listener.get().onCreateTemporaryFunction(normalizedIdentifier.toObjectPath(), catalogFunction);
            }
            try {
                this.validateAndPrepareFunction(identifier.asSummaryString(), catalogFunction);
            }
            catch (Throwable t) {
                throw new ValidationException(String.format("Could not register temporary catalog function '%s' due to implementation errors.", identifier.asSummaryString()), t);
            }
            this.tempCatalogFunctions.put(normalizedIdentifier, catalogFunction);
        } else if (!ignoreIfExists) {
            throw new ValidationException(String.format("Could not register temporary catalog function. A function '%s' does already exist.", identifier.asSummaryString()));
        }
    }

    public boolean dropTemporaryCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, boolean ignoreIfNotExist) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        return this.dropTempCatalogFunction(identifier, ignoreIfNotExist) != null;
    }

    public void registerCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, FunctionDescriptor functionDescriptor, boolean ignoreIfExists) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        CatalogFunctionImpl catalogFunction = new CatalogFunctionImpl(functionDescriptor.getClassName(), functionDescriptor.getLanguage(), functionDescriptor.getResourceUris(), functionDescriptor.getOptions());
        this.registerCatalogFunction(identifier, catalogFunction, ignoreIfExists);
    }

    public boolean dropCatalogFunction(UnresolvedIdentifier unresolvedIdentifier, boolean ignoreIfNotExist) {
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier(identifier);
        Catalog catalog = this.catalogManager.getCatalog(normalizedIdentifier.getCatalogName()).orElseThrow(IllegalStateException::new);
        ObjectPath path = identifier.toObjectPath();
        if (this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            throw new ValidationException(String.format("Could not drop catalog function. A temporary function '%s' does already exist. Please drop the temporary function first.", identifier.asSummaryString()));
        }
        if (!catalog.functionExists(path)) {
            if (ignoreIfNotExist) {
                return false;
            }
            throw new ValidationException(String.format("Could not drop catalog function. A function '%s' doesn't exist.", identifier.asSummaryString()));
        }
        try {
            catalog.dropFunction(path, ignoreIfNotExist);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Could not drop catalog function '%s'.", identifier.asSummaryString()), t);
        }
        return true;
    }

    public String[] getUserDefinedFunctions() {
        return (String[])this.getUserDefinedFunctions(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase()).stream().map(FunctionIdentifier::getFunctionName).toArray(String[]::new);
    }

    public Set<FunctionIdentifier> getUserDefinedFunctions(String catalogName, String databaseName) {
        Set<FunctionIdentifier> result = this.tempSystemFunctions.keySet().stream().map(FunctionIdentifier::of).collect(Collectors.toSet());
        result.addAll(this.tempCatalogFunctions.keySet().stream().filter(oi -> oi.getCatalogName().equals(catalogName) && oi.getDatabaseName().equals(databaseName)).map(FunctionIdentifier::of).collect(Collectors.toSet()));
        this.catalogManager.getCatalog(catalogName).ifPresent(catalog -> result.addAll(FunctionCatalog.getCatalogFunctions(catalog, catalogName, databaseName)));
        return result;
    }

    private static Collection<FunctionIdentifier> getCatalogFunctions(Catalog catalog, String catalogName, String databaseName) {
        try {
            return catalog.listFunctions(databaseName).stream().map(name -> {
                ObjectIdentifier identifier = ObjectIdentifier.of(catalogName, databaseName, name);
                return FunctionIdentifier.of(identifier);
            }).collect(Collectors.toList());
        }
        catch (DatabaseNotExistException e) {
            return Collections.emptyList();
        }
    }

    public String[] getFunctions() {
        return this.getFunctions(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase());
    }

    public String[] getFunctions(String catalogName, String databaseName) {
        Set<String> result = this.getUserDefinedFunctions(catalogName, databaseName).stream().map(FunctionIdentifier::getFunctionName).collect(Collectors.toSet());
        result.addAll(this.moduleManager.listFunctions());
        return result.toArray(new String[0]);
    }

    public boolean hasTemporaryCatalogFunction(ObjectIdentifier functionIdentifier) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier(functionIdentifier);
        return this.tempCatalogFunctions.containsKey(normalizedIdentifier);
    }

    public boolean hasTemporarySystemFunction(String functionName) {
        return this.tempSystemFunctions.containsKey(functionName);
    }

    public FunctionLookup asLookup(final Function<String, UnresolvedIdentifier> parser) {
        return new FunctionLookup(){

            @Override
            public Optional<ContextResolvedFunction> lookupFunction(String stringIdentifier) {
                UnresolvedIdentifier unresolvedIdentifier = (UnresolvedIdentifier)parser.apply(stringIdentifier);
                return this.lookupFunction(unresolvedIdentifier);
            }

            @Override
            public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
                return FunctionCatalog.this.lookupFunction(identifier);
            }
        };
    }

    public Optional<ContextResolvedProcedure> lookupProcedure(UnresolvedIdentifier identifier) {
        ObjectIdentifier procedureIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        Optional<Catalog> catalog = this.catalogManager.getCatalog(procedureIdentifier.getCatalogName());
        if (catalog.isPresent()) {
            Procedure procedure;
            try {
                procedure = catalog.get().getProcedure(procedureIdentifier.toObjectPath());
            }
            catch (ProcedureNotExistException e) {
                return Optional.empty();
            }
            return Optional.of(new ContextResolvedProcedure(FunctionIdentifier.of(procedureIdentifier), procedure));
        }
        return Optional.empty();
    }

    public Optional<ContextResolvedFunction> lookupFunction(UnresolvedIdentifier identifier) {
        if (identifier.getDatabaseName().isPresent()) {
            return this.resolvePreciseFunctionReference(this.catalogManager.qualifyIdentifier(identifier));
        }
        return this.resolveAmbiguousFunctionReference(identifier.getObjectName());
    }

    @Deprecated
    public void registerTempSystemScalarFunction(String name, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareInstance(this.config, function);
        this.registerTempSystemFunction(name, new ScalarFunctionDefinition(name, function));
    }

    @Deprecated
    public <T> void registerTempSystemTableFunction(String name, TableFunction<T> function, TypeInformation<T> resultType) {
        UserDefinedFunctionHelper.prepareInstance(this.config, function);
        this.registerTempSystemFunction(name, new TableFunctionDefinition(name, function, resultType));
    }

    @Deprecated
    public <T, ACC> void registerTempSystemAggregateFunction(String name, ImperativeAggregateFunction<T, ACC> function, TypeInformation<T> resultType, TypeInformation<ACC> accType) {
        FunctionDefinition definition;
        UserDefinedFunctionHelper.prepareInstance(this.config, function);
        if (function instanceof AggregateFunction) {
            definition = new AggregateFunctionDefinition(name, (AggregateFunction)function, resultType, accType);
        } else if (function instanceof TableAggregateFunction) {
            definition = new TableAggregateFunctionDefinition(name, (TableAggregateFunction)function, resultType, accType);
        } else {
            throw new TableException("Unknown function class: " + String.valueOf(function.getClass()));
        }
        this.registerTempSystemFunction(name, definition);
    }

    @Deprecated
    public void registerTempCatalogScalarFunction(ObjectIdentifier oi, ScalarFunction function) {
        UserDefinedFunctionHelper.prepareInstance(this.config, function);
        this.registerTempCatalogFunction(oi, new ScalarFunctionDefinition(oi.getObjectName(), function));
    }

    public CatalogFunction dropTempCatalogFunction(ObjectIdentifier identifier, boolean ignoreIfNotExist) {
        ObjectIdentifier normalizedName = FunctionIdentifier.normalizeObjectIdentifier(identifier);
        CatalogFunction fd = this.tempCatalogFunctions.get(normalizedName);
        if (fd != null) {
            this.catalogManager.getTemporaryOperationListener(normalizedName).ifPresent(l -> l.onDropTemporaryFunction(normalizedName.toObjectPath()));
            this.tempCatalogFunctions.remove(normalizedName);
            this.unregisterFunctionJarResources(fd);
        } else if (!ignoreIfNotExist) {
            throw new ValidationException(String.format("Temporary catalog function %s doesn't exist", identifier));
        }
        return fd;
    }

    @Deprecated
    private void registerTempSystemFunction(String name, FunctionDefinition functionDefinition) {
        this.tempSystemFunctions.put(FunctionIdentifier.normalizeName(name), new InlineCatalogFunction(functionDefinition));
    }

    @Deprecated
    private void registerTempCatalogFunction(ObjectIdentifier oi, FunctionDefinition functionDefinition) {
        this.tempCatalogFunctions.put(FunctionIdentifier.normalizeObjectIdentifier(oi), new InlineCatalogFunction(functionDefinition));
    }

    public void registerTemporarySystemFunction(String name, CatalogFunction function, boolean ignoreIfExists) {
        String normalizedName = FunctionIdentifier.normalizeName(name);
        try {
            this.validateAndPrepareFunction(name, function);
        }
        catch (Throwable t) {
            throw new ValidationException(String.format("Could not register temporary system function '%s' due to implementation errors.", name), t);
        }
        if (!this.tempSystemFunctions.containsKey(normalizedName)) {
            this.tempSystemFunctions.put(normalizedName, function);
        } else if (!ignoreIfExists) {
            throw new ValidationException(String.format("Could not register temporary system function. A function named '%s' does already exist.", name));
        }
    }

    private Optional<ContextResolvedFunction> resolvePreciseFunctionReference(String funcName) {
        if (StringUtils.isNullOrWhitespaceOnly(this.catalogManager.getCurrentCatalog()) || StringUtils.isNullOrWhitespaceOnly(this.catalogManager.getCurrentDatabase())) {
            return Optional.empty();
        }
        ObjectIdentifier oi = ObjectIdentifier.of(this.catalogManager.getCurrentCatalog(), this.catalogManager.getCurrentDatabase(), funcName);
        return this.resolvePreciseFunctionReference(oi);
    }

    private Optional<ContextResolvedFunction> resolvePreciseFunctionReference(ObjectIdentifier oi) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier(oi);
        CatalogFunction potentialResult = this.tempCatalogFunctions.get(normalizedIdentifier);
        if (potentialResult != null) {
            this.registerFunctionJarResources(oi.asSummaryString(), potentialResult.getFunctionResources());
            return Optional.of(ContextResolvedFunction.temporary(FunctionIdentifier.of(oi), this.getFunctionDefinition(oi.getObjectName(), potentialResult), potentialResult));
        }
        Optional<Catalog> catalogOptional = this.catalogManager.getCatalog(oi.getCatalogName());
        if (catalogOptional.isPresent()) {
            Catalog catalog = catalogOptional.get();
            try {
                FunctionDefinition fd;
                CatalogFunction catalogFunction = catalog.getFunction(new ObjectPath(oi.getDatabaseName(), oi.getObjectName()));
                if (catalog.getFunctionDefinitionFactory().isPresent() && catalogFunction.getFunctionLanguage() != FunctionLanguage.PYTHON) {
                    this.registerFunctionJarResources(oi.asSummaryString(), catalogFunction.getFunctionResources());
                    fd = catalog.getFunctionDefinitionFactory().get().createFunctionDefinition(oi.getObjectName(), catalogFunction, this.resourceManager::getUserClassLoader);
                } else {
                    fd = this.getFunctionDefinition(oi.asSummaryString(), catalogFunction);
                }
                return Optional.of(ContextResolvedFunction.permanent(FunctionIdentifier.of(oi), fd, catalogFunction));
            }
            catch (FunctionNotExistException functionNotExistException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private Optional<ContextResolvedFunction> resolveAmbiguousFunctionReference(String funcName) {
        String normalizedName = FunctionIdentifier.normalizeName(funcName);
        if (this.tempSystemFunctions.containsKey(normalizedName)) {
            CatalogFunction function = this.tempSystemFunctions.get(normalizedName);
            this.registerFunctionJarResources(funcName, function.getFunctionResources());
            return Optional.of(ContextResolvedFunction.temporary(FunctionIdentifier.of(funcName), this.getFunctionDefinition(normalizedName, function)));
        }
        Optional<FunctionDefinition> candidate = this.moduleManager.getFunctionDefinition(normalizedName);
        return candidate.map(fd -> Optional.of(ContextResolvedFunction.permanent(FunctionIdentifier.of(funcName), fd))).orElseGet(() -> this.resolvePreciseFunctionReference(funcName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndPrepareFunction(String name, CatalogFunction function) throws ClassNotFoundException, IOException {
        if (function instanceof InlineCatalogFunction) {
            FunctionDefinition definition = ((InlineCatalogFunction)function).getDefinition();
            if (definition instanceof UserDefinedFunction) {
                UserDefinedFunctionHelper.prepareInstance(this.config, (UserDefinedFunction)definition);
            }
        } else if (function.getFunctionLanguage() == FunctionLanguage.JAVA) {
            List<ResourceUri> resourceUris = function.getFunctionResources();
            try {
                if (!resourceUris.isEmpty()) {
                    this.resourceManager.declareFunctionResources(new HashSet<ResourceUri>(function.getFunctionResources()));
                }
            }
            catch (Exception e) {
                throw new TableException(String.format("Failed to register function jar resource '%s' of function '%s'.", resourceUris, name), e);
            }
            URLClassLoader classLoader = this.resourceManager.createUserClassLoader(resourceUris);
            try {
                UserDefinedFunctionHelper.validateClass(classLoader.loadClass(function.getClassName()));
            }
            finally {
                if (!resourceUris.isEmpty()) {
                    classLoader.close();
                }
            }
        }
    }

    private FunctionDefinition getFunctionDefinition(String name, CatalogFunction function) {
        if (function instanceof InlineCatalogFunction) {
            return ((InlineCatalogFunction)function).getDefinition();
        }
        if (function.getFunctionLanguage() == FunctionLanguage.PYTHON) {
            this.resourceManager.registerPythonResources();
        }
        this.registerFunctionJarResources(name, function.getFunctionResources());
        return UserDefinedFunctionHelper.instantiateFunction(this.resourceManager.getUserClassLoader(), this.config, name, function);
    }

    public void registerFunctionJarResources(String functionName, List<ResourceUri> resourceUris) {
        try {
            if (!resourceUris.isEmpty()) {
                this.resourceManager.registerJarResources(resourceUris);
            }
        }
        catch (Exception e) {
            throw new TableException(String.format("Failed to register jar resource '%s' of function '%s'.", resourceUris, functionName), e);
        }
    }

    public FunctionCatalog copy(ResourceManager newResourceManager) {
        return new FunctionCatalog(this.config, newResourceManager, this.catalogManager, this.moduleManager, this.tempSystemFunctions, this.tempCatalogFunctions);
    }

    private void registerCatalogFunction(ObjectIdentifier identifier, CatalogFunction catalogFunction, boolean ignoreIfExists) {
        ObjectIdentifier normalizedIdentifier = FunctionIdentifier.normalizeObjectIdentifier(identifier);
        Catalog catalog = this.catalogManager.getCatalog(normalizedIdentifier.getCatalogName()).orElseThrow(() -> new ValidationException(String.format("Catalog %s not exists.", normalizedIdentifier.getCatalogName())));
        ObjectPath path = identifier.toObjectPath();
        if (this.tempCatalogFunctions.containsKey(normalizedIdentifier)) {
            if (ignoreIfExists) {
                return;
            }
            throw new ValidationException(String.format("Could not register catalog function. A temporary function '%s' does already exist. Please drop the temporary function first.", identifier.asSummaryString()));
        }
        if (catalog.functionExists(path)) {
            if (ignoreIfExists) {
                return;
            }
            throw new ValidationException(String.format("Could not register catalog function. A function '%s' does already exist.", identifier.asSummaryString()));
        }
        try {
            catalog.createFunction(path, catalogFunction, ignoreIfExists);
        }
        catch (Throwable t) {
            throw new TableException(String.format("Could not register catalog function '%s'.", identifier.asSummaryString()), t);
        }
    }

    @Internal
    public static class InlineCatalogFunction
    implements CatalogFunction {
        private final FunctionDefinition definition;

        public InlineCatalogFunction(FunctionDefinition definition) {
            this.definition = definition;
        }

        @Override
        public String getClassName() {
            throw new UnsupportedOperationException("This CatalogFunction is a InlineCatalogFunction. This method should not be called.");
        }

        @Override
        public CatalogFunction copy() {
            return new InlineCatalogFunction(this.definition);
        }

        @Override
        public Optional<String> getDescription() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getDetailedDescription() {
            return Optional.empty();
        }

        @Override
        public FunctionLanguage getFunctionLanguage() {
            return FunctionLanguage.JAVA;
        }

        @Override
        public List<ResourceUri> getFunctionResources() {
            return Collections.emptyList();
        }

        public FunctionDefinition getDefinition() {
            return this.definition;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InlineCatalogFunction that = (InlineCatalogFunction)o;
            return Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hashCode(this.definition);
        }
    }
}

