/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class DefaultResolvedCatalogModel
implements ResolvedCatalogModel,
CatalogModel {
    private final CatalogModel origin;
    private final ResolvedSchema resolvedInputSchema;
    private final ResolvedSchema resolvedOutputSchema;

    public DefaultResolvedCatalogModel(CatalogModel origin, ResolvedSchema resolvedInputSchema, ResolvedSchema resolvedOutputSchema) {
        this.origin = Preconditions.checkNotNull(origin, "Original catalog model must not be null.");
        this.resolvedInputSchema = Preconditions.checkNotNull(resolvedInputSchema, "Resolved input schema must not be null.");
        this.resolvedOutputSchema = Preconditions.checkNotNull(resolvedOutputSchema, "Resolved output schema must not be null.");
    }

    @Override
    public CatalogModel getOrigin() {
        return this.origin;
    }

    @Override
    public ResolvedSchema getResolvedInputSchema() {
        return this.resolvedInputSchema;
    }

    @Override
    public ResolvedSchema getResolvedOutputSchema() {
        return this.resolvedOutputSchema;
    }

    @Override
    public Map<String, String> toProperties(SqlFactory sqlFactory) {
        return CatalogPropertiesUtil.serializeResolvedCatalogModel(this, sqlFactory);
    }

    @Override
    public Map<String, String> getOptions() {
        return this.origin.getOptions();
    }

    @Override
    public Schema getInputSchema() {
        return this.origin.getInputSchema();
    }

    @Override
    public Schema getOutputSchema() {
        return this.origin.getOutputSchema();
    }

    @Override
    public String getComment() {
        return this.origin.getComment();
    }

    @Override
    public ResolvedCatalogModel copy() {
        return new DefaultResolvedCatalogModel(this.origin.copy(), this.resolvedInputSchema, this.resolvedOutputSchema);
    }

    @Override
    public ResolvedCatalogModel copy(Map<String, String> modelOptions) {
        return new DefaultResolvedCatalogModel(this.origin.copy(modelOptions), this.resolvedInputSchema, this.resolvedOutputSchema);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResolvedCatalogModel that = (DefaultResolvedCatalogModel)o;
        return Objects.equals(this.origin, that.origin) && Objects.equals(this.resolvedInputSchema, that.resolvedInputSchema) && Objects.equals(this.resolvedOutputSchema, that.resolvedOutputSchema);
    }

    public int hashCode() {
        return Objects.hash(this.origin, this.resolvedInputSchema, this.resolvedOutputSchema);
    }

    public String toString() {
        return "ResolvedCatalogModel{origin=" + String.valueOf(this.origin) + ", resolvedInputSchema=" + String.valueOf(this.resolvedInputSchema) + ", resolvedOutputSchema=" + String.valueOf(this.resolvedOutputSchema) + "}";
    }
}

