/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateLatencyTrackOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateConfig;
import org.apache.flink.util.Preconditions;

@Internal
public class LatencyTrackingStateConfig
extends MetricsTrackingStateConfig {
    LatencyTrackingStateConfig(MetricGroup metricGroup, boolean enabled, int sampleInterval, int historySize, boolean stateNameAsVariable) {
        super(metricGroup, enabled, sampleInterval, historySize, stateNameAsVariable);
        if (enabled) {
            Preconditions.checkNotNull(metricGroup, "Metric group cannot be null if latency tracking is enabled.");
            Preconditions.checkArgument(sampleInterval >= 1);
        }
    }

    public static LatencyTrackingStateConfig disabled() {
        return ((Builder)LatencyTrackingStateConfig.newBuilder().setEnabled(false)).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends MetricsTrackingStateConfig.Builder<LatencyTrackingStateConfig, Builder> {
        private static final long serialVersionUID = 1L;

        public Builder() {
            this.enabled = StateLatencyTrackOptions.LATENCY_TRACK_ENABLED.defaultValue();
            this.sampleInterval = StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue();
            this.historySize = StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue();
            this.stateNameAsVariable = StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE.defaultValue();
        }

        public Builder configure(ReadableConfig config) {
            ((Builder)((Builder)((Builder)this.setEnabled(config.get(StateLatencyTrackOptions.LATENCY_TRACK_ENABLED))).setSampleInterval(config.get(StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL))).setHistorySize(config.get(StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE))).setStateNameAsVariable(config.get(StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE));
            return this;
        }

        @Override
        public LatencyTrackingStateConfig build() {
            return new LatencyTrackingStateConfig(this.metricGroup, this.enabled, this.sampleInterval, this.historySize, this.stateNameAsVariable);
        }
    }
}

