/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

@Internal
@VisibleForTesting
public final class JavaSerializer<T extends Serializable>
extends TypeSerializerSingleton<T> {
    private static final long serialVersionUID = 5067491650263321234L;

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public T createInstance() {
        return null;
    }

    @Override
    public T copy(T from) {
        try {
            return InstantiationUtil.clone(from, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new FlinkRuntimeException("Could not copy element via serialization: " + String.valueOf(from), e);
        }
    }

    @Override
    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(target);){
            InstantiationUtil.serializeObject(outViewWrapper, record);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T deserialize(DataInputView source) throws IOException {
        try (DataInputViewStream inViewWrapper = new DataInputViewStream(source);){
            Serializable serializable = (Serializable)InstantiationUtil.deserializeObject(inViewWrapper, Thread.currentThread().getContextClassLoader());
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not deserialize object.", e);
        }
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Object tmp = this.deserialize(source);
        this.serialize((T)tmp, target);
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new JavaSerializerSnapshot();
    }

    public static final class JavaSerializerSnapshot<T extends Serializable>
    extends SimpleTypeSerializerSnapshot<T> {
        public JavaSerializerSnapshot() {
            super(JavaSerializer::new);
        }
    }
}

