/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.taskmanager;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.exceptions.UnknownTaskExecutorException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.resourcemanager.AbstractResourceManagerHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.rest.messages.ProfilingInfoList;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class TaskManagerProfilingListHandler
extends AbstractResourceManagerHandler<RestfulGateway, EmptyRequestBody, ProfilingInfoList, TaskManagerMessageParameters> {
    private final GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever;

    public TaskManagerProfilingListHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, ProfilingInfoList, TaskManagerMessageParameters> messageHeaders, GatewayRetriever<ResourceManagerGateway> resourceManagerGatewayRetriever) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, resourceManagerGatewayRetriever);
        this.resourceManagerGatewayRetriever = Preconditions.checkNotNull(resourceManagerGatewayRetriever);
    }

    @Override
    protected CompletableFuture<ProfilingInfoList> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull ResourceManagerGateway gateway) throws RestHandlerException {
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        ResourceManagerGateway resourceManagerGateway = TaskManagerProfilingListHandler.getResourceManagerGateway(this.resourceManagerGatewayRetriever);
        CompletableFuture<Collection<ProfilingInfo>> profilingListFuture = resourceManagerGateway.requestTaskManagerProfilingList(taskManagerId, this.getTimeout());
        return ((CompletableFuture)profilingListFuture.thenApply(ProfilingInfoList::new)).exceptionally(throwable -> {
            Throwable strippedThrowable = ExceptionUtils.stripCompletionException(throwable);
            if (strippedThrowable instanceof UnknownTaskExecutorException) {
                throw new CompletionException(new RestHandlerException("Could not find TaskExecutor " + String.valueOf(taskManagerId), HttpResponseStatus.NOT_FOUND, strippedThrowable));
            }
            throw new CompletionException((Throwable)throwable);
        });
    }
}

