/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.Executor;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractAggregatingMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedSubtaskMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedSubtaskMetricsParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.SubtasksFilterQueryParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.UnionIterator;

public class AggregatingSubtasksMetricsHandler
extends AbstractAggregatingMetricsHandler<AggregatedSubtaskMetricsParameters> {
    public AggregatingSubtasksMetricsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher fetcher) {
        super(leaderRetriever, timeout, responseHeaders, AggregatedSubtaskMetricsHeaders.getInstance(), executor, fetcher);
    }

    @Override
    @Nonnull
    Collection<? extends MetricStore.ComponentMetricStore> getStores(MetricStore store, HandlerRequest<EmptyRequestBody> request) {
        JobID jobID = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID taskID = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        MetricStore.JobMetricStoreSnapshot jobMetrics = store.getJobs();
        List<String> subtaskRanges = request.getQueryParameter(SubtasksFilterQueryParameter.class);
        if (subtaskRanges.isEmpty()) {
            MetricStore.TaskMetricStore taskMetricStore = store.getTaskMetricStore(jobID.toString(), taskID.toString());
            if (taskMetricStore != null) {
                return taskMetricStore.getAllSubtaskMetricStores().values();
            }
            return Collections.emptyList();
        }
        Iterable<Integer> subtasks = this.getIntegerRangeFromString(subtaskRanges);
        ArrayList<MetricStore.ComponentMetricStore> subtaskStores = new ArrayList<MetricStore.ComponentMetricStore>(8);
        for (int subtask : subtasks) {
            MetricStore.ComponentMetricStore subtaskMetricStore = jobMetrics.getSubtaskMetricStore(jobID.toString(), taskID.toString(), subtask);
            if (subtaskMetricStore == null) continue;
            subtaskStores.add(subtaskMetricStore);
        }
        return subtaskStores;
    }

    private Iterable<Integer> getIntegerRangeFromString(Collection<String> ranges) {
        UnionIterator<Integer> iterators = new UnionIterator<Integer>();
        for (String rawRange : ranges) {
            try {
                PrimitiveIterator.OfInt rangeIterator;
                String range = rawRange.trim();
                int dashIdx = range.indexOf(45);
                if (dashIdx == -1) {
                    rangeIterator = Collections.singleton(Integer.valueOf(range)).iterator();
                } else {
                    int start = Integer.valueOf(range.substring(0, dashIdx));
                    int end = Integer.valueOf(range.substring(dashIdx + 1, range.length()));
                    rangeIterator = IntStream.rangeClosed(start, end).iterator();
                }
                iterators.add(rangeIterator);
            }
            catch (NumberFormatException nfe) {
                this.log.warn("Invalid value {} specified for integer range. Not a number.", (Object)rawRange, (Object)nfe);
            }
        }
        return iterators;
    }
}

