/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;

public interface SlotSelectionStrategy {
    public Optional<SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull FreeSlotTracker var1, @Nonnull SlotProfile var2);

    public static enum NoOpSlotSelectionStrategy implements SlotSelectionStrategy
    {
        INSTANCE;


        @Override
        public Optional<SlotInfoAndLocality> selectBestSlotForProfile(@Nonnull FreeSlotTracker freeSlotTracker, @Nonnull SlotProfile slotProfile) {
            return Optional.empty();
        }
    }

    public static final class SlotInfoAndLocality {
        @Nonnull
        private final SlotInfo slotInfo;
        @Nonnull
        private final Locality locality;

        private SlotInfoAndLocality(@Nonnull SlotInfo slotInfo, @Nonnull Locality locality) {
            this.slotInfo = slotInfo;
            this.locality = locality;
        }

        @Nonnull
        public SlotInfo getSlotInfo() {
            return this.slotInfo;
        }

        @Nonnull
        public Locality getLocality() {
            return this.locality;
        }

        public static SlotInfoAndLocality of(@Nonnull SlotInfo slotInfo, @Nonnull Locality locality) {
            return new SlotInfoAndLocality(slotInfo, locality);
        }
    }
}

