/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexSpilledRegionManager;
import org.apache.flink.shaded.guava33.com.google.common.cache.Cache;
import org.apache.flink.shaded.guava33.com.google.common.cache.CacheBuilder;
import org.apache.flink.shaded.guava33.com.google.common.cache.RemovalNotification;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

public class FileDataIndexCache<T extends FileDataIndexRegionHelper.Region> {
    private final List<TreeMap<Integer, T>> subpartitionFirstBufferIndexRegions;
    private final Cache<CachedRegionKey, Object> internalCache;
    private final FileDataIndexSpilledRegionManager<T> spilledRegionManager;
    private final Path indexFilePath;
    public static final Object PLACEHOLDER = new Object();

    public FileDataIndexCache(int numSubpartitions, Path indexFilePath, long numRetainedInMemoryRegionsMax, FileDataIndexSpilledRegionManager.Factory<T> spilledRegionManagerFactory) {
        this.subpartitionFirstBufferIndexRegions = new ArrayList<TreeMap<Integer, T>>(numSubpartitions);
        for (int subpartitionId = 0; subpartitionId < numSubpartitions; ++subpartitionId) {
            this.subpartitionFirstBufferIndexRegions.add(new TreeMap());
        }
        this.internalCache = CacheBuilder.newBuilder().maximumSize(numRetainedInMemoryRegionsMax).removalListener(this::handleRemove).build();
        this.indexFilePath = Preconditions.checkNotNull(indexFilePath);
        this.spilledRegionManager = spilledRegionManagerFactory.create(numSubpartitions, indexFilePath, (subpartition, region) -> {
            if (!this.getCachedRegionContainsTargetBufferIndex((int)subpartition, region.getFirstBufferIndex()).isPresent()) {
                this.subpartitionFirstBufferIndexRegions.get((int)subpartition).put(region.getFirstBufferIndex(), region);
                this.internalCache.put(new CachedRegionKey((int)subpartition, region.getFirstBufferIndex()), PLACEHOLDER);
            } else {
                this.internalCache.getIfPresent(new CachedRegionKey((int)subpartition, region.getFirstBufferIndex()));
            }
        });
    }

    public Optional<T> get(int subpartitionId, int bufferIndex) {
        Optional<T> regionOpt = this.getCachedRegionContainsTargetBufferIndex(subpartitionId, bufferIndex);
        if (regionOpt.isPresent()) {
            FileDataIndexRegionHelper.Region region = (FileDataIndexRegionHelper.Region)regionOpt.get();
            Preconditions.checkNotNull(this.internalCache.getIfPresent(new CachedRegionKey(subpartitionId, region.getFirstBufferIndex())));
            return Optional.of(region);
        }
        this.spilledRegionManager.findRegion(subpartitionId, bufferIndex, true);
        return this.getCachedRegionContainsTargetBufferIndex(subpartitionId, bufferIndex);
    }

    public void put(int subpartition, List<T> fileRegions) {
        TreeMap<Integer, T> treeMap = this.subpartitionFirstBufferIndexRegions.get(subpartition);
        for (FileDataIndexRegionHelper.Region region : fileRegions) {
            this.internalCache.put(new CachedRegionKey(subpartition, region.getFirstBufferIndex()), PLACEHOLDER);
            treeMap.put(region.getFirstBufferIndex(), region);
        }
    }

    public void close() throws IOException {
        this.spilledRegionManager.close();
        IOUtils.deleteFileQuietly(this.indexFilePath);
    }

    private void handleRemove(RemovalNotification<CachedRegionKey, Object> removedEntry) {
        CachedRegionKey removedKey = (CachedRegionKey)removedEntry.getKey();
        FileDataIndexRegionHelper.Region removedRegion = (FileDataIndexRegionHelper.Region)this.subpartitionFirstBufferIndexRegions.get(removedKey.getSubpartition()).remove(removedKey.getFirstBufferIndex());
        this.writeRegion(removedKey.getSubpartition(), removedRegion);
    }

    private void writeRegion(int subpartition, T region) {
        try {
            this.spilledRegionManager.appendOrOverwriteRegion(subpartition, region);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow(e);
        }
    }

    private Optional<T> getCachedRegionContainsTargetBufferIndex(int subpartitionId, int bufferIndex) {
        return Optional.ofNullable(this.subpartitionFirstBufferIndexRegions.get(subpartitionId).floorEntry(bufferIndex)).map(Map.Entry::getValue).filter(internalRegion -> internalRegion.containBuffer(bufferIndex));
    }

    private static class CachedRegionKey {
        private final int subpartition;
        private final int firstBufferIndex;

        public CachedRegionKey(int subpartition, int firstBufferIndex) {
            this.subpartition = subpartition;
            this.firstBufferIndex = firstBufferIndex;
        }

        public int getSubpartition() {
            return this.subpartition;
        }

        public int getFirstBufferIndex() {
            return this.firstBufferIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedRegionKey that = (CachedRegionKey)o;
            return this.subpartition == that.subpartition && this.firstBufferIndex == that.firstBufferIndex;
        }

        public int hashCode() {
            return Objects.hash(this.subpartition, this.firstBufferIndex);
        }
    }
}

