/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpointStats
extends AbstractCheckpointStats {
    private static final long serialVersionUID = 138833868551861344L;
    private final long checkpointedSize;
    private final long stateSize;
    private final long metadataSize;
    private final long processedData;
    private final long persistedData;
    private final boolean unalignedCheckpoint;
    private final SubtaskStateStats latestAcknowledgedSubtask;
    private final String externalPointer;
    private volatile boolean discarded;

    CompletedCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, int numAcknowledgedSubtasks, long stateSize, long metadataSize, long processedData, long persistedData, boolean unalignedCheckpoint, SubtaskStateStats latestAcknowledgedSubtask, String externalPointer) {
        this(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats, numAcknowledgedSubtasks, stateSize, stateSize, metadataSize, processedData, persistedData, unalignedCheckpoint, latestAcknowledgedSubtask, externalPointer);
    }

    CompletedCheckpointStats(long checkpointId, long triggerTimestamp, CheckpointProperties props, int totalSubtaskCount, Map<JobVertexID, TaskStateStats> taskStats, int numAcknowledgedSubtasks, long checkpointedSize, long stateSize, long metadataSize, long processedData, long persistedData, boolean unalignedCheckpoint, SubtaskStateStats latestAcknowledgedSubtask, String externalPointer) {
        super(checkpointId, triggerTimestamp, props, totalSubtaskCount, taskStats);
        Preconditions.checkArgument(numAcknowledgedSubtasks == totalSubtaskCount, "Did not acknowledge all subtasks.");
        Preconditions.checkArgument(checkpointedSize >= 0L, "Negative checkpointed size");
        this.checkpointedSize = checkpointedSize;
        Preconditions.checkArgument(stateSize >= 0L, "Negative state size");
        this.stateSize = stateSize;
        this.metadataSize = metadataSize;
        this.processedData = processedData;
        this.persistedData = persistedData;
        this.unalignedCheckpoint = unalignedCheckpoint;
        this.latestAcknowledgedSubtask = Preconditions.checkNotNull(latestAcknowledgedSubtask);
        this.externalPointer = externalPointer;
    }

    @Override
    public CheckpointStatsStatus getStatus() {
        return CheckpointStatsStatus.COMPLETED;
    }

    @Override
    public int getNumberOfAcknowledgedSubtasks() {
        return this.numberOfSubtasks;
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public long getCheckpointedSize() {
        return this.checkpointedSize;
    }

    @Override
    public long getMetadataSize() {
        return this.metadataSize;
    }

    @Override
    public long getProcessedData() {
        return this.processedData;
    }

    @Override
    public long getPersistedData() {
        return this.persistedData;
    }

    @Override
    public boolean isUnalignedCheckpoint() {
        return this.unalignedCheckpoint;
    }

    @Override
    @Nullable
    public SubtaskStateStats getLatestAcknowledgedSubtaskStats() {
        return this.latestAcknowledgedSubtask;
    }

    public String getExternalPath() {
        return this.externalPointer;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    void discard() {
        this.discarded = true;
    }

    public String toString() {
        return "CompletedCheckpoint(id=" + this.getCheckpointId() + ")";
    }
}

