/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.util.Preconditions;

public class CheckpointOptions
implements Serializable {
    public static final long NO_ALIGNED_CHECKPOINT_TIME_OUT = Long.MAX_VALUE;
    private static final long serialVersionUID = 5010126558083292915L;
    private final SnapshotType checkpointType;
    private final CheckpointStorageLocationReference targetLocation;
    private final AlignmentType alignmentType;
    private final long alignedCheckpointTimeout;
    private static final CheckpointOptions CHECKPOINT_AT_DEFAULT_LOCATION = new CheckpointOptions(CheckpointType.CHECKPOINT, CheckpointStorageLocationReference.getDefault());

    public static CheckpointOptions notExactlyOnce(SnapshotType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.AT_LEAST_ONCE, Long.MAX_VALUE);
    }

    public static CheckpointOptions alignedNoTimeout(SnapshotType type, CheckpointStorageLocationReference location) {
        return new CheckpointOptions(type, location, AlignmentType.ALIGNED, Long.MAX_VALUE);
    }

    public static CheckpointOptions unaligned(SnapshotType type, CheckpointStorageLocationReference location) {
        Preconditions.checkArgument(!type.isSavepoint(), "Savepoints can not be unaligned");
        return new CheckpointOptions(type, location, AlignmentType.UNALIGNED, Long.MAX_VALUE);
    }

    public static CheckpointOptions alignedWithTimeout(SnapshotType type, CheckpointStorageLocationReference location, long alignedCheckpointTimeout) {
        Preconditions.checkArgument(!type.isSavepoint(), "Savepoints can not be unaligned");
        return new CheckpointOptions(type, location, AlignmentType.ALIGNED, alignedCheckpointTimeout);
    }

    private static CheckpointOptions forceAligned(SnapshotType type, CheckpointStorageLocationReference location, long alignedCheckpointTimeout) {
        Preconditions.checkArgument(!type.isSavepoint(), "Savepoints can not be unaligned");
        return new CheckpointOptions(type, location, AlignmentType.FORCED_ALIGNED, alignedCheckpointTimeout);
    }

    public static CheckpointOptions forConfig(SnapshotType checkpointType, CheckpointStorageLocationReference locationReference, boolean isExactlyOnceMode, boolean isUnalignedEnabled, long alignedCheckpointTimeout) {
        if (!isExactlyOnceMode) {
            return CheckpointOptions.notExactlyOnce(checkpointType, locationReference);
        }
        if (checkpointType.isSavepoint()) {
            return CheckpointOptions.alignedNoTimeout(checkpointType, locationReference);
        }
        if (!isUnalignedEnabled) {
            return CheckpointOptions.alignedNoTimeout(checkpointType, locationReference);
        }
        if (alignedCheckpointTimeout == 0L || alignedCheckpointTimeout == Long.MAX_VALUE) {
            return CheckpointOptions.unaligned(checkpointType, locationReference);
        }
        return CheckpointOptions.alignedWithTimeout(checkpointType, locationReference, alignedCheckpointTimeout);
    }

    @VisibleForTesting
    public CheckpointOptions(SnapshotType checkpointType, CheckpointStorageLocationReference targetLocation) {
        this(checkpointType, targetLocation, AlignmentType.ALIGNED, Long.MAX_VALUE);
    }

    public CheckpointOptions(SnapshotType checkpointType, CheckpointStorageLocationReference targetLocation, AlignmentType alignmentType, long alignedCheckpointTimeout) {
        Preconditions.checkArgument(alignmentType != AlignmentType.UNALIGNED || !checkpointType.isSavepoint(), "Savepoint can't be unaligned");
        Preconditions.checkArgument(alignedCheckpointTimeout == Long.MAX_VALUE || alignmentType != AlignmentType.UNALIGNED, "Unaligned checkpoint can't have timeout (%s)", alignedCheckpointTimeout);
        this.checkpointType = Preconditions.checkNotNull(checkpointType);
        this.targetLocation = Preconditions.checkNotNull(targetLocation);
        this.alignmentType = Preconditions.checkNotNull(alignmentType);
        this.alignedCheckpointTimeout = alignedCheckpointTimeout;
    }

    public boolean needsAlignment() {
        return this.isExactlyOnceMode() && (this.getCheckpointType().isSavepoint() || !this.isUnalignedCheckpoint());
    }

    public long getAlignedCheckpointTimeout() {
        return this.alignedCheckpointTimeout;
    }

    public AlignmentType getAlignment() {
        return this.alignmentType;
    }

    public boolean isTimeoutable() {
        if (this.alignmentType == AlignmentType.FORCED_ALIGNED) {
            return false;
        }
        return this.alignmentType == AlignmentType.ALIGNED && this.alignedCheckpointTimeout > 0L && this.alignedCheckpointTimeout != Long.MAX_VALUE;
    }

    public SnapshotType getCheckpointType() {
        return this.checkpointType;
    }

    public CheckpointStorageLocationReference getTargetLocation() {
        return this.targetLocation;
    }

    public boolean isExactlyOnceMode() {
        return this.alignmentType != AlignmentType.AT_LEAST_ONCE;
    }

    public boolean isUnalignedCheckpoint() {
        return this.alignmentType == AlignmentType.UNALIGNED;
    }

    public boolean needsChannelState() {
        return this.isUnalignedCheckpoint() || this.isTimeoutable();
    }

    public CheckpointOptions withUnalignedSupported() {
        if (this.alignmentType == AlignmentType.FORCED_ALIGNED) {
            return this.alignedCheckpointTimeout != Long.MAX_VALUE ? CheckpointOptions.alignedWithTimeout(this.checkpointType, this.targetLocation, this.alignedCheckpointTimeout) : CheckpointOptions.unaligned(this.checkpointType, this.targetLocation);
        }
        return this;
    }

    public CheckpointOptions withUnalignedUnsupported() {
        if (this.needsChannelState()) {
            return CheckpointOptions.forceAligned(this.checkpointType, this.targetLocation, this.alignedCheckpointTimeout);
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetLocation, this.checkpointType, this.alignmentType, this.alignedCheckpointTimeout});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass() == CheckpointOptions.class) {
            CheckpointOptions that = (CheckpointOptions)obj;
            return this.checkpointType.equals(that.checkpointType) && this.targetLocation.equals(that.targetLocation) && this.alignmentType == that.alignmentType && this.alignedCheckpointTimeout == that.alignedCheckpointTimeout;
        }
        return false;
    }

    public String toString() {
        return "CheckpointOptions{checkpointType=" + String.valueOf(this.checkpointType) + ", targetLocation=" + String.valueOf(this.targetLocation) + ", alignmentType=" + String.valueOf((Object)this.alignmentType) + ", alignedCheckpointTimeout=" + this.alignedCheckpointTimeout + "}";
    }

    @VisibleForTesting
    public static CheckpointOptions forCheckpointWithDefaultLocation() {
        return CHECKPOINT_AT_DEFAULT_LOCATION;
    }

    public CheckpointOptions toUnaligned() {
        Preconditions.checkState(this.alignmentType == AlignmentType.ALIGNED);
        return CheckpointOptions.unaligned(this.checkpointType, this.targetLocation);
    }

    public static enum AlignmentType {
        AT_LEAST_ONCE,
        ALIGNED,
        UNALIGNED,
        FORCED_ALIGNED;

    }
}

