/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.asyncprocessing;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.core.asyncprocessing.InternalAsyncFutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
public class CompletedAsyncFuture<T>
implements InternalAsyncFuture<T> {
    T result;

    public CompletedAsyncFuture(T result) {
        this.result = result;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() {
        return this.result;
    }

    @Override
    public <U> InternalAsyncFuture<U> thenApply(FunctionWithException<? super T, ? extends U, ? extends Exception> fn) {
        return InternalAsyncFutureUtils.completedFuture(FunctionWithException.unchecked(fn).apply(this.result));
    }

    @Override
    public InternalAsyncFuture<Void> thenAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
        return InternalAsyncFutureUtils.completedVoidFuture();
    }

    @Override
    public <U> InternalAsyncFuture<U> thenCompose(FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> action) {
        return (InternalAsyncFuture)FunctionWithException.unchecked(action).apply(this.result);
    }

    @Override
    public <U, V> InternalAsyncFuture<V> thenCombine(StateFuture<? extends U> other, BiFunctionWithException<? super T, ? super U, ? extends V, ? extends Exception> fn) {
        return (InternalAsyncFuture)other.thenCompose((? super T u) -> {
            Object v = fn.apply((T)this.result, (Object)u);
            return InternalAsyncFutureUtils.completedFuture(v);
        });
    }

    @Override
    public <U, V> InternalAsyncFuture<Tuple2<Boolean, Object>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends V, ? extends Exception> actionIfFalse) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(this.result) : FunctionWithException.unchecked(actionIfFalse).apply(this.result);
        return InternalAsyncFutureUtils.completedFuture(Tuple2.of(test, r));
    }

    @Override
    public <U> InternalAsyncFuture<Tuple2<Boolean, U>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        Object r = test ? (Object)FunctionWithException.unchecked(actionIfTrue).apply((T)this.result) : null;
        return InternalAsyncFutureUtils.completedFuture(Tuple2.of(test, r));
    }

    @Override
    public InternalAsyncFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue, ThrowingConsumer<? super T, ? extends Exception> actionIfFalse) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            ThrowingConsumer.unchecked(actionIfTrue).accept(this.result);
        } else {
            ThrowingConsumer.unchecked(actionIfFalse).accept(this.result);
        }
        return InternalAsyncFutureUtils.completedFuture(test);
    }

    @Override
    public InternalAsyncFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            ThrowingConsumer.unchecked(actionIfTrue).accept(this.result);
        }
        return InternalAsyncFutureUtils.completedFuture(test);
    }

    @Override
    public <U, V> InternalAsyncFuture<Tuple2<Boolean, Object>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends StateFuture<V>, ? extends Exception> actionIfFalse) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        InternalAsyncFuture actionResult = test ? (InternalAsyncFuture)FunctionWithException.unchecked(actionIfTrue).apply(this.result) : (InternalAsyncFuture)FunctionWithException.unchecked(actionIfFalse).apply(this.result);
        return actionResult.thenApply((T e) -> Tuple2.of(test, e));
    }

    @Override
    public <U> InternalAsyncFuture<Tuple2<Boolean, U>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue) {
        boolean test = FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            StateFuture<Tuple2> actionResult = FunctionWithException.unchecked(actionIfTrue).apply(this.result);
            return (InternalAsyncFuture)actionResult.thenApply((? super T e) -> Tuple2.of(true, e));
        }
        return InternalAsyncFutureUtils.completedFuture(Tuple2.of(false, null));
    }

    @Override
    public void complete(T result) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void completeExceptionally(String message, Throwable ex) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void thenSyncAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
    }
}

