/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class HistoryServerOptions {
    public static final ConfigOption<Duration> HISTORY_SERVER_ARCHIVE_REFRESH_INTERVAL = ConfigOptions.key("historyserver.archive.fs.refresh-interval").durationType().defaultValue(Duration.ofMillis(10000L)).withDescription("Interval for refreshing the archived job directories.");
    public static final ConfigOption<String> HISTORY_SERVER_ARCHIVE_DIRS = ConfigOptions.key("historyserver.archive.fs.dir").stringType().noDefaultValue().withDescription("Comma separated list of directories to fetch archived jobs from. The history server will monitor these directories for archived jobs. You can configure the JobManager to archive jobs to a directory via `jobmanager.archive.fs.dir`.");
    public static final ConfigOption<Boolean> HISTORY_SERVER_CLEANUP_EXPIRED_JOBS = ConfigOptions.key("historyserver.archive.clean-expired-jobs").booleanType().defaultValue(false).withDescription(String.format("Whether HistoryServer should cleanup jobs that are no longer present `%s`.", HISTORY_SERVER_ARCHIVE_DIRS.key()));
    public static final ConfigOption<String> HISTORY_SERVER_TASKMANAGER_LOG_URL_PATTERN = ConfigOptions.key("historyserver.log.taskmanager.url-pattern").stringType().noDefaultValue().withDescription("Pattern of the log URL of TaskManager. The HistoryServer will generate actual URLs from it, with replacing the special placeholders, `<jobid>` and `<tmid>`, to the id of job and TaskManager respectively. Only http / https schemes are supported.");
    public static final ConfigOption<String> HISTORY_SERVER_JOBMANAGER_LOG_URL_PATTERN = ConfigOptions.key("historyserver.log.jobmanager.url-pattern").stringType().noDefaultValue().withDescription("Pattern of the log URL of JobManager. The HistoryServer will generate actual URLs from it, with replacing the special placeholders, `<jobid>`, to the id of job. Only http / https schemes are supported.");
    public static final ConfigOption<String> HISTORY_SERVER_WEB_DIR = ConfigOptions.key("historyserver.web.tmpdir").stringType().noDefaultValue().withDescription("Local directory that is used by the history server REST API for temporary files.");
    public static final ConfigOption<String> HISTORY_SERVER_WEB_ADDRESS = ConfigOptions.key("historyserver.web.address").stringType().noDefaultValue().withDescription("Address of the HistoryServer's web interface.");
    public static final ConfigOption<Integer> HISTORY_SERVER_WEB_PORT = ConfigOptions.key("historyserver.web.port").intType().defaultValue(8082).withDescription("Port of the HistoryServers's web interface.");
    public static final ConfigOption<Duration> HISTORY_SERVER_WEB_REFRESH_INTERVAL = ConfigOptions.key("historyserver.web.refresh-interval").durationType().defaultValue(Duration.ofMillis(10000L)).withDescription("The refresh interval for the HistoryServer web-frontend.");
    public static final ConfigOption<Boolean> HISTORY_SERVER_WEB_SSL_ENABLED = ConfigOptions.key("historyserver.web.ssl.enabled").booleanType().defaultValue(false).withDescription("Enable HTTPs access to the HistoryServer web frontend. This is applicable only when the global SSL flag security.ssl.enabled is set to true.");
    private static final String HISTORY_SERVER_RETAINED_JOBS_KEY = "historyserver.archive.retained-jobs";
    private static final String HISTORY_SERVER_RETAINED_TTL_KEY = "historyserver.archive.retained-ttl";
    private static final String NOTE_MESSAGE = "Note, when there are multiple history server instances, two recommended approaches when using this option are: ";
    private static final String CONFIGURE_SINGLE_INSTANCE = "Specify the option in only one HistoryServer instance to avoid errors caused by multiple instances simultaneously cleaning up remote files, ";
    private static final String CONFIGURE_CONSISTENT = "Or you can keep the value of this configuration consistent across them. ";
    public static final ConfigOption<Integer> HISTORY_SERVER_RETAINED_JOBS = ConfigOptions.key("historyserver.archive.retained-jobs").intType().defaultValue(-1).withDescription(Description.builder().text("The maximum number of jobs to retain in each archive directory defined by %s. ", TextElement.code(HISTORY_SERVER_ARCHIVE_DIRS.key())).list(TextElement.text("If the option is not specified as a positive number without specifying %s, all of the jobs archives will be retained. ", TextElement.code("historyserver.archive.retained-ttl")), TextElement.text("If the option is specified as a positive number without specifying a value of %s, the jobs archive whose order index based modification time is equals to or less than the value will be retained. ", TextElement.code("historyserver.archive.retained-ttl")), TextElement.text("If this option is specified as a positive number together with the specified %s option, the job archive will be removed if its TTL has expired or the retained job count has been reached. ", TextElement.code("historyserver.archive.retained-ttl"))).text("If set to %s or less than %s, HistoryServer will throw an %s. ", TextElement.code("0"), TextElement.code("-1"), TextElement.code("IllegalConfigurationException")).linebreak().text("Note, when there are multiple history server instances, two recommended approaches when using this option are: ").list(TextElement.text("Specify the option in only one HistoryServer instance to avoid errors caused by multiple instances simultaneously cleaning up remote files, "), TextElement.text("Or you can keep the value of this configuration consistent across them. ")).build());
    public static final ConfigOption<Duration> HISTORY_SERVER_RETAINED_TTL = ConfigOptions.key("historyserver.archive.retained-ttl").durationType().noDefaultValue().withDescription(Description.builder().text("The time-to-live duration to retain the jobs archived in each archive directory defined by %s. ", TextElement.code(HISTORY_SERVER_ARCHIVE_DIRS.key())).list(TextElement.text("If the option is not specified without specifying %s, all of the jobs archives will be retained. ", TextElement.code("historyserver.archive.retained-jobs")), TextElement.text("If the option is specified without specifying %s, the jobs archive whose modification time in the time-to-live duration will be retained. ", TextElement.code("historyserver.archive.retained-jobs")), TextElement.text("If this option is specified as a positive time duration together with the %s option, the job archive will be removed if its TTL has expired or the retained job count has been reached. ", TextElement.code("historyserver.archive.retained-jobs"))).text("If set to equal to or less than %s milliseconds, HistoryServer will throw an %s. ", TextElement.code("0"), TextElement.code("IllegalConfigurationException")).linebreak().text("Note, when there are multiple history server instances, two recommended approaches when using this option are: ").list(TextElement.text("Specify the option in only one HistoryServer instance to avoid errors caused by multiple instances simultaneously cleaning up remote files, "), TextElement.text("Or you can keep the value of this configuration consistent across them. ")).build());

    private HistoryServerOptions() {
    }
}

