/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.accumulators.Accumulator;

@Public
public class ListAccumulator<T>
implements Accumulator<T, ArrayList<T>> {
    private static final long serialVersionUID = 1L;
    private ArrayList<T> localValue = new ArrayList();

    @Override
    public void add(T value) {
        this.localValue.add(value);
    }

    @Override
    public ArrayList<T> getLocalValue() {
        return this.localValue;
    }

    @Override
    public void resetLocal() {
        this.localValue.clear();
    }

    @Override
    public void merge(Accumulator<T, ArrayList<T>> other) {
        this.localValue.addAll((Collection)other.getLocalValue());
    }

    @Override
    public Accumulator<T, ArrayList<T>> clone() {
        ListAccumulator<T> newInstance = new ListAccumulator<T>();
        newInstance.localValue = new ArrayList<T>(this.localValue);
        return newInstance;
    }

    public String toString() {
        return "List Accumulator " + String.valueOf(this.localValue);
    }
}

