/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.variant;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.BinaryVariantInternalBuilder;
import org.apache.flink.types.variant.Variant;
import org.apache.flink.types.variant.VariantBuilder;

@Internal
public class BinaryVariantBuilder
implements VariantBuilder {
    @Override
    public Variant of(byte b) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendByte(b);
        return builder.build();
    }

    @Override
    public Variant of(short s) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendShort(s);
        return builder.build();
    }

    @Override
    public Variant of(int i) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendInt(i);
        return builder.build();
    }

    @Override
    public Variant of(long l) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendLong(l);
        return builder.build();
    }

    @Override
    public Variant of(String s) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendString(s);
        return builder.build();
    }

    @Override
    public Variant of(double d) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendDouble(d);
        return builder.build();
    }

    @Override
    public Variant of(float f) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendFloat(f);
        return builder.build();
    }

    @Override
    public Variant of(byte[] bytes) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendBinary(bytes);
        return builder.build();
    }

    @Override
    public Variant of(boolean b) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendBoolean(b);
        return builder.build();
    }

    @Override
    public Variant of(BigDecimal bigDecimal) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendDecimal(bigDecimal);
        return builder.build();
    }

    @Override
    public Variant of(Instant instant) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendTimestampLtz(ChronoUnit.MICROS.between(Instant.EPOCH, instant));
        return builder.build();
    }

    @Override
    public Variant of(LocalDate localDate) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendDate((int)localDate.toEpochDay());
        return builder.build();
    }

    @Override
    public Variant of(LocalDateTime localDateTime) {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendTimestamp(ChronoUnit.MICROS.between(Instant.EPOCH, localDateTime.toInstant(ZoneOffset.UTC)));
        return builder.build();
    }

    @Override
    public Variant ofNull() {
        BinaryVariantInternalBuilder builder = new BinaryVariantInternalBuilder(false);
        builder.appendNull();
        return builder.build();
    }

    @Override
    public VariantObjectBuilder object() {
        return this.object(false);
    }

    @Override
    public VariantObjectBuilder object(boolean allowDuplicateKeys) {
        return new VariantObjectBuilder(allowDuplicateKeys);
    }

    @Override
    public VariantArrayBuilder array() {
        return new VariantArrayBuilder();
    }

    @PublicEvolving
    public static class VariantArrayBuilder
    implements VariantBuilder.VariantArrayBuilder {
        private final BinaryVariantInternalBuilder builder;
        private final ArrayList<Integer> offsets = new ArrayList();

        public VariantArrayBuilder() {
            this.builder = new BinaryVariantInternalBuilder(false);
        }

        @Override
        public VariantArrayBuilder add(Variant value) {
            this.offsets.add(this.builder.getWritePos());
            this.builder.appendVariant((BinaryVariant)value);
            return this;
        }

        @Override
        public Variant build() {
            this.builder.finishWritingArray(0, this.offsets);
            return this.builder.build();
        }
    }

    @PublicEvolving
    public static class VariantObjectBuilder
    implements VariantBuilder.VariantObjectBuilder {
        private final BinaryVariantInternalBuilder builder;
        private final ArrayList<BinaryVariantInternalBuilder.FieldEntry> entries = new ArrayList();

        public VariantObjectBuilder(boolean allowDuplicateKeys) {
            this.builder = new BinaryVariantInternalBuilder(allowDuplicateKeys);
        }

        @Override
        public VariantObjectBuilder add(String key, Variant value) {
            int id = this.builder.addKey(key);
            this.entries.add(new BinaryVariantInternalBuilder.FieldEntry(key, id, this.builder.getWritePos()));
            this.builder.appendVariant((BinaryVariant)value);
            return this;
        }

        @Override
        public Variant build() {
            this.builder.finishWritingObject(0, this.entries);
            return this.builder.build();
        }
    }
}

