/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.endpoint;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpoint;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactory;

@PublicEvolving
public class SqlGatewayEndpointFactoryUtils {
    public static final String GATEWAY_ENDPOINT_PREFIX = "sql-gateway.endpoint";

    public static List<SqlGatewayEndpoint> createSqlGatewayEndpoint(SqlGatewayService service, Configuration configuration) {
        List<String> identifiers = configuration.get(FactoryUtil.SQL_GATEWAY_ENDPOINT_TYPE);
        if (identifiers == null || identifiers.isEmpty()) {
            throw new ValidationException(String.format("Endpoint options do not contain an option key '%s' for discovering an endpoint.", FactoryUtil.SQL_GATEWAY_ENDPOINT_TYPE.key()));
        }
        SqlGatewayEndpointFactoryUtils.validateSpecifiedEndpointsAreUnique(identifiers);
        ArrayList<SqlGatewayEndpoint> endpoints = new ArrayList<SqlGatewayEndpoint>();
        for (String identifier : identifiers) {
            SqlGatewayEndpointFactory factory = FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), SqlGatewayEndpointFactory.class, identifier);
            endpoints.add(factory.createSqlGatewayEndpoint(new DefaultEndpointFactoryContext(service, configuration, SqlGatewayEndpointFactoryUtils.getEndpointConfig(configuration, identifier))));
        }
        return endpoints;
    }

    public static Map<String, String> getEndpointConfig(Configuration flinkConf, String identifier) {
        return new DelegatingConfiguration(flinkConf, SqlGatewayEndpointFactoryUtils.getSqlGatewayOptionPrefix(identifier)).toMap();
    }

    public static String getSqlGatewayOptionPrefix(String identifier) {
        return String.format("%s.%s.", GATEWAY_ENDPOINT_PREFIX, identifier);
    }

    public static EndpointFactoryHelper createEndpointFactoryHelper(SqlGatewayEndpointFactory endpointFactory, SqlGatewayEndpointFactory.Context context) {
        return new EndpointFactoryHelper(endpointFactory, context.getEndpointOptions());
    }

    private static void validateSpecifiedEndpointsAreUnique(List<String> identifiers) {
        HashSet<String> uniqueIdentifiers = new HashSet<String>();
        for (String identifier : identifiers) {
            if (uniqueIdentifiers.contains(identifier)) {
                throw new ValidationException(String.format("Get the duplicate endpoint identifier '%s' for the option '%s'. Please keep the specified endpoint identifier unique.", identifier, FactoryUtil.SQL_GATEWAY_ENDPOINT_TYPE.key()));
            }
            uniqueIdentifiers.add(identifier);
        }
    }

    @Internal
    public static class DefaultEndpointFactoryContext
    implements SqlGatewayEndpointFactory.Context {
        private final SqlGatewayService service;
        private final Configuration flinkConfiguration;
        private final Map<String, String> endpointConfig;

        public DefaultEndpointFactoryContext(SqlGatewayService service, Configuration flinkConfiguration, Map<String, String> endpointConfig) {
            this.service = service;
            this.flinkConfiguration = flinkConfiguration;
            this.endpointConfig = endpointConfig;
        }

        @Override
        public SqlGatewayService getSqlGatewayService() {
            return this.service;
        }

        @Override
        public ReadableConfig getFlinkConfiguration() {
            return this.flinkConfiguration;
        }

        @Override
        public Map<String, String> getEndpointOptions() {
            return this.endpointConfig;
        }
    }

    @PublicEvolving
    public static class EndpointFactoryHelper
    extends FactoryUtil.FactoryHelper<SqlGatewayEndpointFactory> {
        private EndpointFactoryHelper(SqlGatewayEndpointFactory factory, Map<String, String> configOptions) {
            super(factory, configOptions, FactoryUtil.PROPERTY_VERSION);
        }
    }
}

