/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArrayComparator;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class DynamicFilteringData
implements Serializable {
    private final TypeInformation<RowData> typeInfo;
    private final RowType rowType;
    private final List<byte[]> serializedData;
    private final boolean isFiltering;
    private volatile transient boolean prepared = false;
    private transient Map<Integer, List<RowData>> dataMap;
    private transient RowData.FieldGetter[] fieldGetters;

    public DynamicFilteringData(TypeInformation<RowData> typeInfo, RowType rowType, List<byte[]> serializedData, boolean isFiltering) {
        this.typeInfo = Preconditions.checkNotNull(typeInfo);
        this.rowType = Preconditions.checkNotNull(rowType);
        this.serializedData = Preconditions.checkNotNull(serializedData);
        this.isFiltering = isFiltering;
    }

    public boolean isFiltering() {
        return this.isFiltering;
    }

    public RowType getRowType() {
        return this.rowType;
    }

    public boolean contains(RowData row) {
        if (!this.isFiltering) {
            return true;
        }
        if (row.getArity() != this.rowType.getFieldCount()) {
            throw new TableException("The arity of RowData is different");
        }
        this.prepare();
        List<RowData> mayMatchRowData = this.dataMap.get(this.hash(row));
        if (mayMatchRowData == null) {
            return false;
        }
        for (RowData mayMatch : mayMatchRowData) {
            if (!this.matchRow(row, mayMatch)) continue;
            return true;
        }
        return false;
    }

    private boolean matchRow(RowData row, RowData mayMatch) {
        for (int i = 0; i < this.rowType.getFieldCount(); ++i) {
            if (Objects.equals(this.fieldGetters[i].getFieldOrNull(row), this.fieldGetters[i].getFieldOrNull(mayMatch))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare() {
        if (!this.prepared) {
            DynamicFilteringData dynamicFilteringData = this;
            synchronized (dynamicFilteringData) {
                if (!this.prepared) {
                    this.doPrepare();
                    this.prepared = true;
                }
            }
        }
    }

    private void doPrepare() {
        this.dataMap = new HashMap<Integer, List<RowData>>();
        if (this.isFiltering) {
            this.fieldGetters = (RowData.FieldGetter[])IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> RowData.createFieldGetter(this.rowType.getTypeAt(i), i)).toArray(RowData.FieldGetter[]::new);
            TypeSerializer<RowData> serializer = this.typeInfo.createSerializer(new SerializerConfigImpl());
            for (byte[] bytes : this.serializedData) {
                try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                     DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(bais);){
                    RowData partition = serializer.deserialize(inView);
                    List partitions = this.dataMap.computeIfAbsent(this.hash(partition), k -> new ArrayList());
                    partitions.add(partition);
                }
                catch (Exception e) {
                    throw new TableException("Unable to deserialize the value.", e);
                }
            }
        }
    }

    private int hash(RowData row) {
        return Objects.hash(Arrays.stream(this.fieldGetters).map(g -> g.getFieldOrNull(row)).toArray());
    }

    public static boolean isEqual(DynamicFilteringData data, DynamicFilteringData another) {
        if (data == null) {
            return another == null;
        }
        if (another == null || data.isFiltering != another.isFiltering || !data.typeInfo.equals(another.typeInfo) || !data.rowType.equals(another.rowType) || data.serializedData.size() != another.serializedData.size()) {
            return false;
        }
        BytePrimitiveArrayComparator comparator = new BytePrimitiveArrayComparator(true);
        for (int i = 0; i < data.serializedData.size(); ++i) {
            if (comparator.compare(data.serializedData.get(i), another.serializedData.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public Collection<RowData> getData() {
        this.prepare();
        return this.dataMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        return "DynamicFilteringData{isFiltering=" + this.isFiltering + ", data size=" + this.serializedData.size() + "}";
    }
}

