/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.expressions.SqlFactory;

@PublicEvolving
public class EnvironmentSettings {
    private final Configuration configuration;
    private final ClassLoader classLoader;
    @Nullable
    private final CatalogStore catalogStore;
    @Nullable
    private final SqlFactory sqlFactory;

    private EnvironmentSettings(Configuration configuration, ClassLoader classLoader, CatalogStore catalogStore, SqlFactory sqlFactory) {
        this.configuration = configuration;
        this.classLoader = classLoader;
        this.catalogStore = catalogStore;
        this.sqlFactory = sqlFactory;
    }

    public static EnvironmentSettings inStreamingMode() {
        return EnvironmentSettings.newInstance().inStreamingMode().build();
    }

    public static EnvironmentSettings inBatchMode() {
        return EnvironmentSettings.newInstance().inBatchMode().build();
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getBuiltInCatalogName() {
        return this.configuration.get(TableConfigOptions.TABLE_CATALOG_NAME);
    }

    public String getBuiltInDatabaseName() {
        return this.configuration.get(TableConfigOptions.TABLE_DATABASE_NAME);
    }

    public boolean isStreamingMode() {
        return this.configuration.get(ExecutionOptions.RUNTIME_MODE) == RuntimeExecutionMode.STREAMING;
    }

    @Internal
    public ClassLoader getUserClassLoader() {
        return this.classLoader;
    }

    @Internal
    @Nullable
    public CatalogStore getCatalogStore() {
        return this.catalogStore;
    }

    @Internal
    public Optional<SqlFactory> getSqlFactory() {
        return Optional.ofNullable(this.sqlFactory);
    }

    @PublicEvolving
    public static class Builder {
        private final Configuration configuration = new Configuration();
        private ClassLoader classLoader;
        @Nullable
        private CatalogStore catalogStore;
        @Nullable
        private SqlFactory sqlFactory;

        public Builder inBatchMode() {
            this.configuration.set((ConfigOption)ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH);
            return this;
        }

        public Builder inStreamingMode() {
            this.configuration.set((ConfigOption)ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.configuration.set((ConfigOption)TableConfigOptions.TABLE_CATALOG_NAME, builtInCatalogName);
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.configuration.set((ConfigOption)TableConfigOptions.TABLE_DATABASE_NAME, builtInDatabaseName);
            return this;
        }

        public Builder withConfiguration(Configuration configuration) {
            this.configuration.addAll(configuration);
            return this;
        }

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withCatalogStore(CatalogStore catalogStore) {
            this.catalogStore = catalogStore;
            return this;
        }

        public Builder withSqlFactory(SqlFactory sqlFactory) {
            this.sqlFactory = sqlFactory;
            return this;
        }

        public EnvironmentSettings build() {
            if (this.classLoader == null) {
                this.classLoader = Thread.currentThread().getContextClassLoader();
            }
            return new EnvironmentSettings(this.configuration, this.classLoader, this.catalogStore, this.sqlFactory);
        }
    }
}

