/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.api.connector.sink2.SupportsCommitter;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.connector.sink2.SupportsPostCommitTopology;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperator;
import org.apache.flink.util.Preconditions;

@Internal
public final class CommitterOperatorFactory<CommT>
extends AbstractStreamOperatorFactory<CommittableMessage<CommT>>
implements OneInputStreamOperatorFactory<CommittableMessage<CommT>, CommittableMessage<CommT>> {
    private final SupportsCommitter<CommT> sink;
    private final boolean isBatchMode;
    private final boolean isCheckpointingEnabled;

    public CommitterOperatorFactory(SupportsCommitter<CommT> sink, boolean isBatchMode, boolean isCheckpointingEnabled) {
        this.sink = Preconditions.checkNotNull(sink);
        this.isBatchMode = isBatchMode;
        this.isCheckpointingEnabled = isCheckpointingEnabled;
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<CommT>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<CommT>> parameters) {
        try {
            CommitterOperator<CommT> committerOperator = new CommitterOperator<CommT>(parameters, this.processingTimeService, this.sink.getCommittableSerializer(), context -> this.sink.createCommitter((CommitterInitContext)context), this.sink instanceof SupportsPostCommitTopology, this.isBatchMode, this.isCheckpointingEnabled);
            return (T)committerOperator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CommitterOperator.class;
    }
}

