/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.util.Preconditions;

public final class TaskExecutorRegistrationSuccess
extends RegistrationResponse.Success
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InstanceID registrationId;
    private final ResourceID resourceManagerResourceId;
    private final ClusterInformation clusterInformation;
    @Nullable
    private final byte[] initialTokens;

    public TaskExecutorRegistrationSuccess(InstanceID registrationId, ResourceID resourceManagerResourceId, ClusterInformation clusterInformation, @Nullable byte[] initialTokens) {
        this.registrationId = Preconditions.checkNotNull(registrationId);
        this.resourceManagerResourceId = Preconditions.checkNotNull(resourceManagerResourceId);
        this.clusterInformation = Preconditions.checkNotNull(clusterInformation);
        this.initialTokens = initialTokens;
    }

    public InstanceID getRegistrationId() {
        return this.registrationId;
    }

    public ResourceID getResourceManagerId() {
        return this.resourceManagerResourceId;
    }

    public ClusterInformation getClusterInformation() {
        return this.clusterInformation;
    }

    public byte[] getInitialTokens() {
        return this.initialTokens;
    }

    @Override
    public String toString() {
        return "TaskExecutorRegistrationSuccess{registrationId=" + String.valueOf(this.registrationId) + ", resourceManagerResourceId=" + String.valueOf(this.resourceManagerResourceId) + ", clusterInformation=" + String.valueOf(this.clusterInformation) + "}";
    }
}

