/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateSizeTrackOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.metrics.MetricsTrackingStateConfig;

@Internal
public class SizeTrackingStateConfig
extends MetricsTrackingStateConfig {
    SizeTrackingStateConfig(MetricGroup metricGroup, boolean enabled, int sampleInterval, int historySize, boolean stateNameAsVariable) {
        super(metricGroup, enabled, sampleInterval, historySize, stateNameAsVariable);
    }

    public static SizeTrackingStateConfig disabled() {
        return ((Builder)SizeTrackingStateConfig.newBuilder().setEnabled(false)).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends MetricsTrackingStateConfig.Builder<SizeTrackingStateConfig, Builder> {
        private static final long serialVersionUID = 1L;

        public Builder() {
            this.enabled = StateSizeTrackOptions.SIZE_TRACK_ENABLED.defaultValue();
            this.sampleInterval = StateSizeTrackOptions.SIZE_TRACK_SAMPLE_INTERVAL.defaultValue();
            this.historySize = StateSizeTrackOptions.SIZE_TRACK_HISTORY_SIZE.defaultValue();
            this.stateNameAsVariable = StateSizeTrackOptions.SIZE_TRACK_STATE_NAME_AS_VARIABLE.defaultValue();
        }

        public Builder configure(ReadableConfig config) {
            ((Builder)((Builder)((Builder)this.setEnabled(config.get(StateSizeTrackOptions.SIZE_TRACK_ENABLED))).setSampleInterval(config.get(StateSizeTrackOptions.SIZE_TRACK_SAMPLE_INTERVAL))).setHistorySize(config.get(StateSizeTrackOptions.SIZE_TRACK_HISTORY_SIZE))).setStateNameAsVariable(config.get(StateSizeTrackOptions.SIZE_TRACK_STATE_NAME_AS_VARIABLE));
            return this;
        }

        @Override
        public SizeTrackingStateConfig build() {
            return new SizeTrackingStateConfig(this.metricGroup, this.enabled, this.sampleInterval, this.historySize, this.stateNameAsVariable);
        }
    }
}

