/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class VertexParallelism {
    private final Map<JobVertexID, Integer> parallelismForVertices;

    public VertexParallelism(Map<JobVertexID, Integer> parallelismForVertices) {
        this.parallelismForVertices = parallelismForVertices;
    }

    public int getParallelism(JobVertexID jobVertexId) {
        Preconditions.checkArgument(this.parallelismForVertices.containsKey(jobVertexId), "Unknown vertex: " + String.valueOf(jobVertexId));
        return this.parallelismForVertices.get(jobVertexId);
    }

    public Optional<Integer> getParallelismOptional(JobVertexID jobVertexId) {
        return Optional.ofNullable(this.parallelismForVertices.get(jobVertexId));
    }

    public Set<JobVertexID> getVertices() {
        return Collections.unmodifiableSet(this.parallelismForVertices.keySet());
    }

    public String toString() {
        return "VertexParallelism: " + String.valueOf(this.parallelismForVertices);
    }

    public static VertexParallelism empty() {
        return new VertexParallelism(Collections.emptyMap());
    }
}

