/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.FailureLabelFilterParameter;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.UpperLimitExceptionParameter;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.curator5.com.google.common.collect.Iterables;
import org.apache.flink.util.Preconditions;

public class JobExceptionsHandler
extends AbstractExecutionGraphHandler<JobExceptionsInfoWithHistory, JobExceptionsMessageParameters>
implements JsonArchivist {
    static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;
    static final List<FailureLabelFilterParameter.FailureLabel> EMPTY_FAILURE_LABEL_FILTER = Collections.emptyList();

    public JobExceptionsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Duration timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobExceptionsInfoWithHistory, JobExceptionsMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobExceptionsInfoWithHistory handleRequest(HandlerRequest<EmptyRequestBody> request, ExecutionGraphInfo executionGraph) {
        List exceptionToReportMaxSizes = request.getQueryParameter(UpperLimitExceptionParameter.class);
        int exceptionToReportMaxSize = exceptionToReportMaxSizes.size() > 0 ? (Integer)exceptionToReportMaxSizes.get(0) : 20;
        List<FailureLabelFilterParameter.FailureLabel> failureLabelFilter = request.getQueryParameter(FailureLabelFilterParameter.class);
        failureLabelFilter = failureLabelFilter.size() > 0 ? failureLabelFilter : EMPTY_FAILURE_LABEL_FILTER;
        return JobExceptionsHandler.createJobExceptionsInfo(executionGraph, exceptionToReportMaxSize, failureLabelFilter);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(ExecutionGraphInfo executionGraphInfo) throws IOException {
        JobExceptionsInfoWithHistory json = JobExceptionsHandler.createJobExceptionsInfo(executionGraphInfo, 20, EMPTY_FAILURE_LABEL_FILTER);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", executionGraphInfo.getJobId().toString());
        return Collections.singletonList(new ArchivedJson(path, json));
    }

    private static JobExceptionsInfoWithHistory createJobExceptionsInfo(ExecutionGraphInfo executionGraphInfo, int exceptionToReportMaxSize, List<FailureLabelFilterParameter.FailureLabel> failureLabelFilter) {
        return new JobExceptionsInfoWithHistory(JobExceptionsHandler.createJobExceptionHistory(executionGraphInfo.getExceptionHistory(), exceptionToReportMaxSize, failureLabelFilter));
    }

    private static JobExceptionsInfoWithHistory.JobExceptionHistory createJobExceptionHistory(Iterable<RootExceptionHistoryEntry> historyEntries, int limit, List<FailureLabelFilterParameter.FailureLabel> failureLabelFilter) {
        List<JobExceptionsInfoWithHistory.RootExceptionInfo> exceptionHistoryEntries;
        List<Object> reversedHistoryEntries = new ArrayList();
        Iterables.addAll(reversedHistoryEntries, historyEntries);
        Collections.reverse(reversedHistoryEntries);
        if (!failureLabelFilter.isEmpty()) {
            reversedHistoryEntries = reversedHistoryEntries.stream().filter(entry -> {
                for (FailureLabelFilterParameter.FailureLabel label : failureLabelFilter) {
                    if (entry.getFailureLabels().containsKey(label.getKey()) && entry.getFailureLabels().get(label.getKey()).equals(label.getValue())) continue;
                    return false;
                }
                return true;
            }).collect(Collectors.toList());
        }
        return new JobExceptionsInfoWithHistory.JobExceptionHistory(exceptionHistoryEntries, (exceptionHistoryEntries = reversedHistoryEntries.stream().limit(limit).map(JobExceptionsHandler::createRootExceptionInfo).collect(Collectors.toList())).size() < reversedHistoryEntries.size());
    }

    private static JobExceptionsInfoWithHistory.RootExceptionInfo createRootExceptionInfo(RootExceptionHistoryEntry historyEntry) {
        List<JobExceptionsInfoWithHistory.ExceptionInfo> concurrentExceptions = StreamSupport.stream(historyEntry.getConcurrentExceptions().spliterator(), false).map(JobExceptionsHandler::createExceptionInfo).collect(Collectors.toList());
        if (historyEntry.isGlobal()) {
            return new JobExceptionsInfoWithHistory.RootExceptionInfo(historyEntry.getException().getOriginalErrorClassName(), historyEntry.getExceptionAsString(), historyEntry.getTimestamp(), historyEntry.getFailureLabels(), concurrentExceptions);
        }
        JobExceptionsHandler.assertLocalExceptionInfo(historyEntry);
        return new JobExceptionsInfoWithHistory.RootExceptionInfo(historyEntry.getException().getOriginalErrorClassName(), historyEntry.getExceptionAsString(), historyEntry.getTimestamp(), historyEntry.getFailureLabels(), historyEntry.getFailingTaskName(), JobExceptionsHandler.toString(historyEntry.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId(historyEntry.getTaskManagerLocation()), concurrentExceptions);
    }

    private static JobExceptionsInfoWithHistory.ExceptionInfo createExceptionInfo(ExceptionHistoryEntry exceptionHistoryEntry) {
        if (exceptionHistoryEntry.isGlobal()) {
            return new JobExceptionsInfoWithHistory.ExceptionInfo(exceptionHistoryEntry.getException().getOriginalErrorClassName(), exceptionHistoryEntry.getExceptionAsString(), exceptionHistoryEntry.getTimestamp(), exceptionHistoryEntry.getFailureLabels(), null, null, null);
        }
        JobExceptionsHandler.assertLocalExceptionInfo(exceptionHistoryEntry);
        return new JobExceptionsInfoWithHistory.ExceptionInfo(exceptionHistoryEntry.getException().getOriginalErrorClassName(), exceptionHistoryEntry.getExceptionAsString(), exceptionHistoryEntry.getTimestamp(), exceptionHistoryEntry.getFailureLabels(), exceptionHistoryEntry.getFailingTaskName(), JobExceptionsHandler.toString(exceptionHistoryEntry.getTaskManagerLocation()), JobExceptionsHandler.toTaskManagerId(exceptionHistoryEntry.getTaskManagerLocation()));
    }

    private static void assertLocalExceptionInfo(ExceptionHistoryEntry exceptionHistoryEntry) {
        Preconditions.checkArgument(exceptionHistoryEntry.getFailingTaskName() != null, "The taskName must not be null for a non-global failure.");
    }

    @VisibleForTesting
    static String toString(@Nullable TaskManagerLocation location) {
        return location != null ? location.getEndpoint() : "(unassigned)";
    }

    @VisibleForTesting
    static String toTaskManagerId(@Nullable TaskManagerLocation location) {
        return location != null ? String.format("%s", location.getResourceID()) : "(unassigned)";
    }

    @Nullable
    @VisibleForTesting
    static String toString(@Nullable ExceptionHistoryEntry.ArchivedTaskManagerLocation location) {
        return location != null ? location.getEndpoint() : null;
    }

    @VisibleForTesting
    static String toTaskManagerId(@Nullable ExceptionHistoryEntry.ArchivedTaskManagerLocation location) {
        return location != null ? String.format("%s", location.getResourceID()) : null;
    }
}

