/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.scope;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public abstract class ScopeFormat {
    public static final String SCOPE_INHERIT_PARENT = "*";
    public static final String SCOPE_SEPARATOR = ".";
    private static final String SCOPE_VARIABLE_PREFIX = "<";
    private static final String SCOPE_VARIABLE_SUFFIX = ">";
    public static final String SCOPE_HOST = ScopeFormat.asVariable("host");
    public static final String SCOPE_TASKMANAGER_ID = ScopeFormat.asVariable("tm_id");
    public static final String SCOPE_JOB_ID = ScopeFormat.asVariable("job_id");
    public static final String SCOPE_JOB_NAME = ScopeFormat.asVariable("job_name");
    public static final String SCOPE_TASK_VERTEX_ID = ScopeFormat.asVariable("task_id");
    public static final String SCOPE_TASK_NAME = ScopeFormat.asVariable("task_name");
    public static final String SCOPE_TASK_ATTEMPT_ID = ScopeFormat.asVariable("task_attempt_id");
    public static final String SCOPE_TASK_ATTEMPT_NUM = ScopeFormat.asVariable("task_attempt_num");
    public static final String SCOPE_TASK_SUBTASK_INDEX = ScopeFormat.asVariable("subtask_index");
    public static final String SCOPE_OPERATOR_ID = ScopeFormat.asVariable("operator_id");
    public static final String SCOPE_OPERATOR_NAME = ScopeFormat.asVariable("operator_name");
    private final String format;
    private final String[] template;
    private final int[] templatePos;
    private final int[] valuePos;

    protected ScopeFormat(String format, ScopeFormat parent, String[] variables) {
        boolean parentAsPrefix;
        Preconditions.checkNotNull(format, "format is null");
        String[] rawComponents = format.split("\\.");
        boolean bl = parentAsPrefix = rawComponents.length > 0 && rawComponents[0].equals(SCOPE_INHERIT_PARENT);
        if (parentAsPrefix) {
            if (parent == null) {
                throw new IllegalArgumentException("Component scope format requires parent prefix (starts with '*'), but this component has no parent (is root component).");
            }
            this.format = format.length() > 2 ? format.substring(2) : "<empty>";
            String[] parentTemplate = parent.template;
            int parentLen = parentTemplate.length;
            this.template = new String[parentLen + rawComponents.length - 1];
            System.arraycopy(parentTemplate, 0, this.template, 0, parentLen);
            System.arraycopy(rawComponents, 1, this.template, parentLen, rawComponents.length - 1);
        } else {
            this.format = format.isEmpty() ? "<empty>" : format;
            this.template = rawComponents;
        }
        HashMap<String, Integer> varToValuePos = ScopeFormat.arrayToMap(variables);
        ArrayList<Integer> templatePos = new ArrayList<Integer>();
        ArrayList<Integer> valuePos = new ArrayList<Integer>();
        for (int i = 0; i < this.template.length; ++i) {
            Integer replacementPos;
            String component = this.template[i];
            if (component == null || component.length() < 3 || component.charAt(0) != '<' || component.charAt(component.length() - 1) != '>' || (replacementPos = varToValuePos.get(component)) == null) continue;
            templatePos.add(i);
            valuePos.add(replacementPos);
        }
        this.templatePos = ScopeFormat.integerListToArray(templatePos);
        this.valuePos = ScopeFormat.integerListToArray(valuePos);
    }

    public String format() {
        return this.format;
    }

    protected final String[] copyTemplate() {
        String[] copy = new String[this.template.length];
        System.arraycopy(this.template, 0, copy, 0, this.template.length);
        return copy;
    }

    protected final String[] bindVariables(String[] template, String[] values) {
        int len = this.templatePos.length;
        for (int i = 0; i < len; ++i) {
            template[this.templatePos[i]] = values[this.valuePos[i]];
        }
        return template;
    }

    public String toString() {
        return "ScopeFormat '" + this.format + "'";
    }

    public static String asVariable(String scope) {
        return SCOPE_VARIABLE_PREFIX + scope + SCOPE_VARIABLE_SUFFIX;
    }

    public static String concat(CharacterFilter filter, Character delimiter, String ... components) {
        StringBuilder sb = new StringBuilder();
        sb.append(filter.filterCharacters(components[0]));
        for (int x = 1; x < components.length; ++x) {
            sb.append(delimiter);
            sb.append(filter.filterCharacters(components[x]));
        }
        return sb.toString();
    }

    protected static String valueOrNull(Object value) {
        return value == null || value instanceof String && ((String)value).isEmpty() ? "null" : value.toString();
    }

    protected static HashMap<String, Integer> arrayToMap(String[] array) {
        HashMap<String, Integer> map = CollectionUtil.newHashMapWithExpectedSize(array.length);
        for (int i = 0; i < array.length; ++i) {
            map.put(array[i], i);
        }
        return map;
    }

    private static int[] integerListToArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int pos = 0;
        for (Integer i : list) {
            array[pos++] = i;
        }
        return array;
    }
}

